/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class BaseGradient
extends Java2Dresource {
    private int width;
    private int height;
    private int gradientHeight;
    private String baseColor;
    private String gradientColor;
    private boolean horizontal = false;

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        this.width = width;
        this.height = height;
        this.gradientHeight = gradientHeight;
        this.baseColor = baseColor != null ? baseColor : "headerBackgroundColor";
        this.gradientColor = gradientColor != null ? gradientColor : "headerGradientColor";
        this.horizontal = horizontal;
        this.setRenderer(new PngRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public BaseGradient(int width, int height, int gradientHeight) {
        this(width, height, gradientHeight, null, null, false);
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        this(width, height, gradientHeight, baseColor, gradientColor, false);
    }

    public BaseGradient(int width, int height) {
        this(width, height, height);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor) {
        this(width, height, height, baseColor, gradientColor);
    }

    public BaseGradient() {
        this(30, 50, 20);
    }

    public BaseGradient(String baseColor, String gradientColor) {
        this(30, 50, 20, baseColor, gradientColor);
    }

    public BaseGradient(int width, int height, int gradientHeight, boolean horizontal) {
        this(width, height, gradientHeight, null, null, horizontal);
    }

    public BaseGradient(int width, int height, boolean horizontal) {
        this(width, height, horizontal ? width : height, null, null, horizontal);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, horizontal ? width : height, baseColor, gradientColor, horizontal);
    }

    public BaseGradient(boolean horizontal) {
        this(30, 50, 20, null, null, horizontal);
    }

    public BaseGradient(String baseColor, String gradientColor, boolean horizontal) {
        this(30, 50, 20, baseColor, gradientColor, horizontal);
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return new Dimension(this.width, this.height);
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimensions(null, this.restoreData(resourceContext));
    }

    private void drawGradient(Graphics2D g2d, Rectangle2D rectangle, GradientType.BiColor colors, int height) {
        if (colors != null) {
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, colors.getTopColor(), 0.0f, height, colors.getBottomColor());
            g2d.setPaint(gragient);
            g2d.fill(rectangle);
        }
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Data dataToStore = (Data)this.restoreData(resourceContext);
        if (dataToStore != null) {
            Integer headerBackgroundColor = dataToStore.getHeaderBackgroundColor();
            Integer headerGradientColor = dataToStore.getHeaderGradientColor();
            if (headerBackgroundColor != null && headerGradientColor != null) {
                int localGradientHeight;
                GradientType.BiColor biColor = new GradientType.BiColor(headerBackgroundColor, headerGradientColor);
                GradientType type = dataToStore.getGradientType();
                GradientType.BiColor firstLayer = type.getFirstLayerColors(biColor);
                GradientType.BiColor secondLayer = type.getSecondLayerColors(biColor);
                Dimension dim = this.getDimensions(null, dataToStore);
                if (this.horizontal) {
                    g2d.transform(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
                    dim.setSize(dim.height, dim.width);
                }
                if ((localGradientHeight = this.gradientHeight) < 0) {
                    localGradientHeight = dim.height;
                }
                Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
                this.drawGradient(g2d, rect, firstLayer, localGradientHeight);
                int smallGradientHeight = localGradientHeight / 2;
                rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, smallGradientHeight);
                this.drawGradient(g2d, rect, secondLayer, smallGradientHeight);
            }
        }
    }

    protected void restoreData(Data data, Zipper2 zipper2) {
        if (zipper2.hasMore()) {
            data.setHeaderBackgroundColor(zipper2.nextIntColor());
            data.setHeaderGradientColor(zipper2.nextIntColor());
            data.setGradientType(GradientType.values()[zipper2.nextByte()]);
        }
    }

    protected Object deserializeData(byte[] objectArray) {
        Data data = this.createData();
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            this.restoreData(data, zipper2);
        }
        return data;
    }

    protected Data createData() {
        return new Data();
    }

    private Integer decodeColor(String value) {
        if (value != null && value.length() != 0) {
            return HtmlColor.decode(value).getRGB();
        }
        return null;
    }

    protected void saveData(FacesContext context, Data data, Object parameterData) {
        Integer baseIntColor = null;
        Integer headerIntColor = null;
        String gradientTypeString = null;
        if (baseIntColor == null) {
            baseIntColor = this.getColorValueParameter(context, this.baseColor, false);
        }
        if (headerIntColor == null) {
            headerIntColor = this.getColorValueParameter(context, this.gradientColor, false);
        }
        if (baseIntColor != null || headerIntColor != null) {
            if (baseIntColor == null) {
                baseIntColor = this.getColorValueParameter(context, this.baseColor, true);
            }
            if (headerIntColor == null) {
                headerIntColor = this.getColorValueParameter(context, this.gradientColor, true);
            }
        }
        data.setHeaderBackgroundColor(baseIntColor);
        data.setHeaderGradientColor(headerIntColor);
        if (gradientTypeString == null || gradientTypeString.length() == 0) {
            gradientTypeString = this.getValueParameter(context, "gradientType");
        }
        data.setGradientType(GradientType.getByParameter(gradientTypeString));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Data dataObject = this.createData();
        this.saveData(context, dataObject, data);
        return dataObject.toByteArray();
    }

    public boolean isCacheable() {
        return true;
    }

    protected String getValueParameter(FacesContext context, String name) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String value = (String)skin.getParameter(context, name);
        if (value == null || value.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }

    protected Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
        Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
        return this.decodeColor((String)skin.getParameter(context, name));
    }

    protected static class Data
    implements Serializable {
        private static final long serialVersionUID = 1732700513743861250L;
        private Integer headerBackgroundColor;
        private Integer headerGradientColor;
        private GradientType gradientType;

        public byte[] toByteArray() {
            if (this.headerBackgroundColor != null && this.headerGradientColor != null && this.gradientType != null) {
                byte[] ret = new byte[7];
                new Zipper2(ret).addColor(this.headerBackgroundColor).addColor(this.headerGradientColor).addByte((byte)this.gradientType.ordinal());
                return ret;
            }
            return null;
        }

        public Integer getHeaderBackgroundColor() {
            return this.headerBackgroundColor;
        }

        public void setHeaderBackgroundColor(Integer headerBackgroundColor) {
            this.headerBackgroundColor = headerBackgroundColor;
        }

        public Integer getHeaderGradientColor() {
            return this.headerGradientColor;
        }

        public void setHeaderGradientColor(Integer headerGradientColor) {
            this.headerGradientColor = headerGradientColor;
        }

        public GradientType getGradientType() {
            return this.gradientType;
        }

        public void setGradientType(GradientType gradientType) {
            this.gradientType = gradientType;
        }
    }
}

