/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.XMLFragment;
import org.w3c.dom.Element;

public class EnvelopeBuilderStax
implements EnvelopeBuilder {
    private static final String END_ELEMENT_BRACKET = "</";
    private static final String EMPTY_STRING = "";
    private static final String CLOSING_BRACKET = ">";
    private static final String START_ELEMENT_BRACKET = "<";
    private static final String HEADER_ELEMENT_NAME = "Header";
    private static final String BODY_ELEMENT_NAME = "Body";
    private static final String FAULT_ELEMENT_NAME = "Fault";
    private Part currentPart = Part.ENVELOPE;
    private Part previousPart = null;
    private SOAPPartImpl soapPart;
    private SOAPEnvelopeImpl soapEnv;
    private StringBuffer fragmentBuffer;
    private QName fragmentRootCursor = null;
    private QName currentRootElement = null;
    private XMLStreamReader reader;
    private static XMLInputFactory factory;

    public EnvelopeBuilderStax() {
        this.resetFragmentBuffer();
    }

    private void resetFragmentBuffer() {
        this.fragmentBuffer = new StringBuffer();
        this.fragmentBuffer.ensureCapacity(2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SOAPEnvelope build(SOAPMessage soapMessage, InputStream in, boolean ignoreParseError) throws IOException, SOAPException {
        block20: {
            try {
                this.reader = EnvelopeBuilderStax.getFactoryInstance().createXMLStreamReader(in);
            }
            catch (XMLStreamException e) {
                throw new IOException("Failed to create stream reader:" + e.getMessage());
            }
            this.soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
            while (this.reader.hasNext()) {
                if (this.reader.isStartElement()) {
                    this.processStartElement();
                } else if (this.reader.isCharacters()) {
                    this.processCharacters();
                } else if (this.reader.isEndElement()) {
                    this.processEndElement();
                }
                this.reader.next();
            }
            Object var6_6 = null;
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
                break block20;
            }
            catch (XMLStreamException e2) {}
            break block20;
            {
                catch (XMLStreamException e) {
                    if (!ignoreParseError) {
                        throw new IOException("Failed to parse stream: " + e.getMessage());
                    }
                    Object var6_7 = null;
                    try {
                        if (this.reader != null) {
                            this.reader.close();
                        }
                        break block20;
                    }
                    catch (XMLStreamException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                }
                catch (XMLStreamException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return this.soapEnv;
    }

    private static synchronized XMLInputFactory getFactoryInstance() {
        if (null == factory) {
            System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
            factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        }
        return factory;
    }

    private void processCharacters() throws SOAPException {
        if (this.fragmentRootCursor != null) {
            this.consumeCharacters();
        }
    }

    private void consumeCharacters() throws SOAPException {
        String text = EnvelopeBuilderStax.normalize(this.reader.getText());
        if (!this.atPartMargin() && !this.reader.isWhiteSpace()) {
            this.fragmentBuffer.append(text);
            if (Part.FAULT == this.currentPart) {
                String localName = this.currentRootElement.getLocalPart();
                SOAPFault fault = this.soapEnv.getBody().getFault();
                if ("faultcode".equalsIgnoreCase(localName)) {
                    fault.setFaultCode(text);
                } else if ("faultactor".equalsIgnoreCase(localName)) {
                    fault.setFaultActor(text);
                } else if ("faultstring".equalsIgnoreCase(localName)) {
                    fault.setFaultString(text);
                }
            }
        }
    }

    private void processEndElement() throws SOAPException {
        if (this.fragmentRootCursor != null) {
            this.consumeEndElement();
        }
    }

    private void consumeEndElement() throws SOAPException {
        QName qName = this.reader.getName();
        this.fragmentBuffer.append(END_ELEMENT_BRACKET);
        this.fragmentBuffer.append(this.getFQElementName(qName));
        this.fragmentBuffer.append(CLOSING_BRACKET);
        if (this.fragmentRootCursor != null && this.fragmentRootCursor.equals(qName)) {
            this.flushBuffer();
            this.fragmentRootCursor = null;
        }
    }

    private void flushBuffer() throws SOAPException {
        if (Part.HEADER == this.currentPart) {
            SOAPHeader soapHeader = this.soapEnv.getHeader();
            SOAPContentElement lastHeaderElement = (SOAPContentElement)((Object)soapHeader.getChildNodes().item(soapHeader.getChildNodes().getLength() - 1));
            lastHeaderElement.setXMLFragment(this.bufferToFragment(this.fragmentBuffer));
        } else if (Part.BODY == this.currentPart) {
            SOAPBody soapBody = this.soapEnv.getBody();
            SOAPContentElement lastBodyElement = (SOAPContentElement)((Object)soapBody.getChildNodes().item(soapBody.getChildNodes().getLength() - 1));
            lastBodyElement.setXMLFragment(this.bufferToFragment(this.fragmentBuffer));
        } else if (Part.FAULT == this.currentPart) {
            SOAPBody soapBody = this.soapEnv.getBody();
            SOAPContentElement faultElement = (SOAPContentElement)soapBody.getFault();
            faultElement.setXMLFragment(this.bufferToFragment(this.fragmentBuffer));
        }
        this.resetFragmentBuffer();
    }

    private XMLFragment bufferToFragment(StringBuffer fragmentBuffer) {
        StreamSource source = new StreamSource(new ByteArrayInputStream(fragmentBuffer.toString().getBytes()));
        return new XMLFragment(source);
    }

    private void processStartElement() throws SOAPException {
        QName qName;
        this.currentRootElement = qName = this.reader.getName();
        this.togglePartMargin(qName);
        SOAPElementImpl destElement = null;
        if (Part.ENVELOPE == this.currentPart) {
            destElement = this.soapEnv = new SOAPEnvelopeImpl(this.soapPart, qName.getNamespaceURI(), false);
        } else if (Part.HEADER == this.currentPart) {
            if (this.atPartMargin()) {
                SOAPHeader soapHeader = this.soapEnv.getHeader();
                destElement = soapHeader;
                this.previousPart = Part.HEADER;
            } else {
                if (this.fragmentRootCursor == null) {
                    NameImpl name = new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                    SOAPHeaderElementImpl headerElement = new SOAPHeaderElementImpl(name);
                    this.soapEnv.getHeader().addChildElement((SOAPElement)headerElement);
                    destElement = headerElement;
                    this.fragmentRootCursor = qName;
                }
                this.consumeStartElement();
            }
        } else if (Part.BODY == this.currentPart) {
            SOAPBody soapBody = this.soapEnv.getBody();
            if (this.atPartMargin()) {
                destElement = soapBody;
                this.previousPart = Part.BODY;
            } else {
                NameImpl bodyElementName = new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
                if (this.fragmentRootCursor == null) {
                    SOAPBodyElementDoc docBodyElement = new SOAPBodyElementDoc(bodyElementName);
                    docBodyElement = (SOAPBodyElementDoc)soapBody.addChildElement((SOAPElement)docBodyElement);
                    destElement = docBodyElement;
                    this.fragmentRootCursor = qName;
                }
                this.consumeStartElement();
            }
        } else if (Part.FAULT == this.currentPart) {
            if (this.atPartMargin()) {
                SOAPBody soapBody = this.soapEnv.getBody();
                SOAPFaultImpl soapFault = new SOAPFaultImpl(this.soapEnv.getPrefix(), this.soapEnv.getNamespaceURI());
                soapBody.addChildElement((SOAPElement)soapFault);
                destElement = soapFault;
                this.previousPart = Part.FAULT;
            }
            if (this.fragmentRootCursor == null) {
                this.fragmentRootCursor = qName;
            }
            this.consumeStartElement();
        }
        if (this.fragmentRootCursor == null) {
            this.copyAttributes((Element)((Object)destElement));
        }
    }

    private void togglePartMargin(QName qName) {
        if (qName.getLocalPart().equalsIgnoreCase(HEADER_ELEMENT_NAME)) {
            this.previousPart = this.currentPart;
            this.currentPart = Part.HEADER;
        } else if (qName.getLocalPart().equalsIgnoreCase(BODY_ELEMENT_NAME)) {
            this.previousPart = this.currentPart;
            this.currentPart = Part.BODY;
        } else if (qName.getLocalPart().equalsIgnoreCase(FAULT_ELEMENT_NAME)) {
            this.previousPart = this.currentPart;
            this.currentPart = Part.FAULT;
        }
    }

    private void consumeStartElement() {
        QName qName = this.reader.getName();
        this.fragmentBuffer.append(START_ELEMENT_BRACKET);
        this.fragmentBuffer.append(this.getFQElementName(qName));
        for (int x = 0; x < this.reader.getNamespaceCount(); ++x) {
            if (this.reader.getNamespacePrefix(x) != null) {
                this.fragmentBuffer.append(" xmlns:");
                this.fragmentBuffer.append(this.reader.getNamespacePrefix(x)).append("='");
                this.fragmentBuffer.append(this.reader.getNamespaceURI(x)).append("'");
                continue;
            }
            if (this.reader.getNamespaceURI(x) == null) continue;
            this.fragmentBuffer.append(" xmlns='");
            this.fragmentBuffer.append(this.reader.getNamespaceURI(x)).append("'");
        }
        if (this.reader.getAttributeCount() > 0) {
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                QName attQName = this.reader.getAttributeName(i);
                this.fragmentBuffer.append(" ").append(this.getFQElementName(attQName));
                this.fragmentBuffer.append("='").append(this.reader.getAttributeValue(i)).append("'");
            }
        }
        this.fragmentBuffer.append(CLOSING_BRACKET);
    }

    private String getFQElementName(QName qName) {
        return !qName.getPrefix().equals(EMPTY_STRING) ? qName.getPrefix() + ":" + qName.getLocalPart() : qName.getLocalPart();
    }

    private void copyAttributes(Element destElement) {
        if (this.reader.getAttributeCount() == 0) {
            return;
        }
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            destElement.setAttributeNS(this.reader.getAttributeNamespace(i), this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
        }
    }

    private boolean atPartMargin() {
        return this.previousPart != this.currentPart;
    }

    private static String normalize(String valueStr) {
        int i;
        boolean found = false;
        block9: for (i = 0; i < valueStr.length(); ++i) {
            switch (valueStr.charAt(i)) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    found = true;
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (!found) {
            return valueStr;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(valueStr.substring(0, i));
        while (i < valueStr.length()) {
            char c = valueStr.charAt(i);
            switch (c) {
                case '<': {
                    builder.append("&lt;");
                    break;
                }
                case '>': {
                    builder.append("&gt;");
                    break;
                }
                case '&': {
                    builder.append("&amp;");
                    break;
                }
                case '\"': {
                    builder.append("&quot;");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public SOAPEnvelope build(SOAPMessage soapMessage, Reader reader, boolean ignoreParseError) throws IOException, SOAPException {
        throw new NotImplementedException();
    }

    public SOAPEnvelope build(SOAPMessage soapMessage, Element domEnv) throws SOAPException {
        throw new NotImplementedException();
    }

    public SOAPBodyElement buildBodyElementDoc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        throw new NotImplementedException();
    }

    public SOAPBodyElement buildBodyElementRpc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        throw new NotImplementedException();
    }

    public Style getStyle() {
        throw new NotImplementedException();
    }

    public void setStyle(Style style) {
        throw new NotImplementedException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Part {
        ENVELOPE,
        HEADER,
        BODY,
        FAULT,
        RPC_PAYLOAD,
        DOC_PAYLOAD,
        BARE_PAYLOAD;

    }
}

