/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.test;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.DebugUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractManagedComponentTest {
    private final Log log = LogFactory.getLog(this.getClass());
    protected ManagementView managementView;

    public AbstractManagedComponentTest(ProfileServiceConnection connection) {
        System.out.println("Initializing profile service...");
        this.managementView = connection.getManagementView();
        this.managementView.load();
    }

    protected Set<ManagedProperty> getMandatoryProperties(DeploymentTemplateInfo template) {
        Map managedProperties = template.getProperties();
        HashSet<ManagedProperty> mandatoryProperties = new HashSet<ManagedProperty>();
        for (ManagedProperty managedProperty : managedProperties.values()) {
            if (!managedProperty.isMandatory()) continue;
            mandatoryProperties.add(managedProperty);
        }
        return mandatoryProperties;
    }

    protected Set<ManagedProperty> getNonMandatoryProperties(DeploymentTemplateInfo template) {
        Map managedProperties = template.getProperties();
        HashSet<ManagedProperty> mandatoryProperties = new HashSet<ManagedProperty>();
        for (ManagedProperty managedProperty : managedProperties.values()) {
            if (managedProperty.isMandatory()) continue;
            mandatoryProperties.add(managedProperty);
        }
        return mandatoryProperties;
    }

    protected ManagedComponent createComponent(ComponentType componentType, String componentName, DeploymentTemplateInfo template) throws Exception {
        this.log.info((Object)("Creating new " + componentType + " component with properties:\n" + DebugUtils.convertPropertiesToString(template.getProperties()) + "..."));
        this.managementView.applyTemplate(componentName, template);
        this.managementView.process();
        ManagedComponent component = this.managementView.getComponent(componentName, componentType);
        assert (component != null);
        assert (component.getType().equals((Object)componentType));
        assert (component.getName().equals(componentName));
        return component;
    }

    protected void createComponentWithFailureExpected(ComponentType componentType, String componentName, DeploymentTemplateInfo template) throws Exception {
        this.log.info((Object)("Creating new " + componentType + " component with properties:\n" + DebugUtils.convertPropertiesToString(template.getProperties()) + "..."));
        try {
            this.managementView.applyTemplate(componentName, template);
            this.managementView.process();
        }
        catch (Exception e) {
            this.log.info((Object)("Exception thrown as expected: " + e));
        }
        ManagedComponent component = this.managementView.getComponent(componentName, componentType);
        if (component != null) {
            this.managementView.removeComponent(component);
        }
        assert (component == null);
    }

    protected void setSimpleStringProperty(Map<String, ManagedProperty> properties, String propName, String propValue) {
        if (!properties.containsKey(propName)) {
            properties.put(propName, (ManagedProperty)new ManagedPropertyImpl(propName));
        }
        ManagedProperty property = properties.get(propName);
        property.setValue((MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)propValue)));
    }
}

