/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyWriter;

public class StAXPolicyWriter
implements PolicyWriter {
    private int num = 1;

    StAXPolicyWriter() {
    }

    public void writePolicy(Policy policy, OutputStream output) {
        XMLStreamWriter writer = null;
        try {
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
            this.writePolicy(policy, writer);
            writer.flush();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writePolicy(Policy policy, XMLStreamWriter writer) throws XMLStreamException {
        String writerPerfix = writer.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (writerPerfix != null) {
            writer.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        } else {
            writer.writeStartElement("wsp", "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        }
        if (policy.getId() != null) {
            writer.writeNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            writer.setPrefix("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            writer.writeAttribute("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", policy.getId());
        }
        Iterator iterator = policy.getTerms().iterator();
        while (iterator.hasNext()) {
            Assertion term = (Assertion)iterator.next();
            this.writeAssertion(term, writer);
        }
        writer.writeEndElement();
    }

    private void writeAssertion(Assertion assertion, XMLStreamWriter writer) throws XMLStreamException {
        if (assertion instanceof PrimitiveAssertion) {
            this.writePrimitiveAssertion((PrimitiveAssertion)assertion, writer);
        } else if (assertion instanceof XorCompositeAssertion) {
            this.writeXorCompositeAssertion((XorCompositeAssertion)assertion, writer);
        } else if (assertion instanceof PolicyReference) {
            this.writePolicyReference((PolicyReference)assertion, writer);
        } else if (assertion instanceof Policy) {
            this.writePolicy((Policy)assertion, writer);
        } else if (assertion instanceof AndCompositeAssertion) {
            this.writeAndCompositeAssertion((AndCompositeAssertion)assertion, writer);
        } else {
            throw new RuntimeException("unknown element type");
        }
    }

    private void writeAndCompositeAssertion(AndCompositeAssertion assertion, XMLStreamWriter writer) throws XMLStreamException {
        String writerPrefix = writer.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (writerPrefix == null) {
            writer.writeStartElement("wsp", "All", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        } else {
            writer.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "All");
        }
        List terms = assertion.getTerms();
        this.writeTerms(terms, writer);
        writer.writeEndElement();
    }

    private void writeXorCompositeAssertion(XorCompositeAssertion assertion, XMLStreamWriter writer) throws XMLStreamException {
        String writerPrefix = writer.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (writerPrefix == null) {
            writer.writeStartElement("wsp", "ExactlyOne", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        } else {
            writer.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne");
        }
        List terms = assertion.getTerms();
        this.writeTerms(terms, writer);
        writer.writeEndElement();
    }

    private void writePrimitiveAssertion(PrimitiveAssertion assertion, XMLStreamWriter writer) throws XMLStreamException {
        QName qname = assertion.getName();
        String writerPrefix = writer.getPrefix(qname.getNamespaceURI());
        if (writerPrefix != null) {
            writer.writeStartElement(qname.getNamespaceURI(), qname.getLocalPart());
        } else {
            String prefix = qname.getPrefix() != null ? qname.getPrefix() : this.generateNamespace();
            writer.writeStartElement(prefix, qname.getLocalPart(), qname.getNamespaceURI());
            writer.writeNamespace(prefix, qname.getNamespaceURI());
            writer.setPrefix(prefix, qname.getNamespaceURI());
        }
        Hashtable attributes = assertion.getAttributes();
        this.writeAttributes(attributes, writer);
        String text = assertion.getStrValue();
        if (text != null) {
            writer.writeCharacters(text);
        }
        List terms = assertion.getTerms();
        this.writeTerms(terms, writer);
        writer.writeEndElement();
    }

    public void writePolicyReference(PolicyReference assertion, XMLStreamWriter writer) throws XMLStreamException {
        String writerPrefix = writer.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (writerPrefix != null) {
            writer.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference");
        } else {
            writer.writeStartElement("wsp", "PolicyReference", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        }
        writer.writeAttribute("URI", assertion.getPolicyURIString());
        writer.writeEndElement();
    }

    private void writeTerms(List terms, XMLStreamWriter writer) throws XMLStreamException {
        Iterator iterator = terms.iterator();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            this.writeAssertion(assertion, writer);
        }
    }

    private void writeAttributes(Hashtable attributes, XMLStreamWriter writer) throws XMLStreamException {
        Iterator iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            QName qname = (QName)iterator.next();
            String value = (String)attributes.get(qname);
            String prefix = qname.getPrefix();
            if (prefix != null) {
                writer.writeAttribute(prefix, qname.getNamespaceURI(), qname.getLocalPart(), value);
                continue;
            }
            writer.writeAttribute(qname.getNamespaceURI(), qname.getLocalPart(), value);
        }
    }

    private String generateNamespace() {
        return "ns" + this.num++;
    }
}

