/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAdapterDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>();
        SystemInfo sysInfo = discoveryContext.getSystemInformation();
        if (!sysInfo.isNative()) {
            this.log.debug((Object)("Skipping " + discoveryContext.getResourceType().getName() + " discovery, since native system info is not available."));
            return results;
        }
        for (NetworkAdapterInfo info : sysInfo.getAllNetworkAdapters()) {
            Configuration configuration = discoveryContext.getDefaultPluginConfiguration();
            configuration.put((Property)new PropertySimple("macAddress", (Object)info.getMacAddressString()));
            DiscoveredResourceDetails found = new DiscoveredResourceDetails(discoveryContext.getResourceType(), info.getName(), info.getDisplayName(), null, info.getMacAddressString(), configuration, null);
            results.add(found);
        }
        return results;
    }
}

