/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;

public class ConnectionImpleJDBC3
extends ConnectionImple
implements Connection {
    public ConnectionImpleJDBC3(String dbName, Properties info) throws SQLException {
        super(dbName, info);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        this.getConnection().setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.setsavepointerror"));
        }
        return this.getConnection().setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.setsavepointerror"));
        }
        return this.getConnection().setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.rollbacksavepointerror"));
        }
        this.getConnection().rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.transactionRunning()) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.releasesavepointerror"));
        }
        this.getConnection().releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        this.registerDatabase();
        return this.getConnection().prepareStatement(sql, columnNames);
    }
}

