/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.manager.interfaces.impl;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.jboss.console.navtree.AppletBrowser;
import org.jboss.console.navtree.AppletTreeAction;
import org.jboss.console.navtree.TreeContext;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.AbstractXYDataset;

public class GraphMBeanAttributeAction
implements AppletTreeAction {
    protected ObjectName targetObjectName = null;
    protected String attr = null;
    protected transient ChartFrame frame = null;
    protected transient MBeanXYDataset dataset = null;

    public GraphMBeanAttributeAction() {
    }

    public GraphMBeanAttributeAction(ObjectName pName, String attr) {
        this.targetObjectName = pName;
        this.attr = attr;
    }

    public void doAction(TreeContext tc, AppletBrowser applet) {
        try {
            if (this.frame == null) {
                this.dataset = new MBeanXYDataset();
                JFreeChart chart = ChartFactory.createXYLineChart("JMX Attribute: " + this.attr, "count", this.attr, this.dataset, PlotOrientation.VERTICAL, true, true, false);
                UpdateThread update = new UpdateThread(this.dataset, tc);
                Thread thread = new Thread(update);
                thread.start();
                this.frame = new ChartFrame("JMX Attribute: " + this.attr, chart);
                this.frame.getChartPanel().setPreferredSize(new Dimension(500, 270));
                this.frame.pack();
            } else {
                this.dataset.clear();
            }
            this.frame.show();
            this.frame.requestFocus();
        }
        catch (Exception displayed) {
            displayed.printStackTrace();
        }
    }

    public class UpdateThread
    implements Runnable {
        MBeanXYDataset data;
        TreeContext tc;

        public UpdateThread(MBeanXYDataset data, TreeContext tc) {
            this.data = data;
            this.tc = tc;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (GraphMBeanAttributeAction.this.frame.isShowing()) {
                            Object val = this.tc.getRemoteMBeanInvoker().getAttribute(GraphMBeanAttributeAction.this.targetObjectName, GraphMBeanAttributeAction.this.attr);
                            System.out.println("added value: " + val);
                            this.data.add(val);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class MBeanXYDataset
    extends AbstractXYDataset {
        private ArrayList data = new ArrayList();

        public void clear() {
            this.data.clear();
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }

        public void add(Object num) {
            this.data.add(num);
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }

        public Number getX(int series, int item) {
            return item;
        }

        public Number getY(int series, int item) {
            return (Number)this.data.get(item);
        }

        public double getXValue(int series, int item) {
            return item;
        }

        public double getYValue(int series, int item) {
            double result = Double.NaN;
            Number x = (Number)this.data.get(item);
            if (x != null) {
                result = x.doubleValue();
            }
            return result;
        }

        public Comparable getSeriesKey(int series) {
            return "graph";
        }

        public int getSeriesCount() {
            return 1;
        }

        public String getSeriesName(int series) {
            return "y = " + GraphMBeanAttributeAction.this.attr;
        }

        public int getItemCount(int series) {
            return this.data.size();
        }
    }
}

