/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.util.ArrayList;
import java.util.List;
import org.jfree.base.Library;

public class BasicProjectInfo
extends Library {
    private String copyright;
    private List libraries = new ArrayList();
    private List optionalLibraries = new ArrayList();

    public BasicProjectInfo() {
    }

    public BasicProjectInfo(String name, String version, String licence, String info) {
        this();
        this.setName(name);
        this.setVersion(version);
        this.setLicenceName(licence);
        this.setInfo(info);
    }

    public BasicProjectInfo(String name, String version, String info, String copyright, String licenceName) {
        this(name, version, licenceName, info);
        this.setCopyright(copyright);
    }

    public void addLibrary(Library library) {
        if (library == null) {
            throw new NullPointerException();
        }
        this.libraries.add(library);
    }

    public void addOptionalLibrary(String libraryClass) {
        if (libraryClass == null) {
            throw new NullPointerException("Library classname must be given.");
        }
        this.optionalLibraries.add(new OptionalLibraryHolder(libraryClass));
    }

    public void addOptionalLibrary(Library library) {
        if (library == null) {
            throw new NullPointerException("Library must be given.");
        }
        this.optionalLibraries.add(new OptionalLibraryHolder(library));
    }

    public String getCopyright() {
        return this.copyright;
    }

    public Library[] getLibraries() {
        return this.libraries.toArray(new Library[this.libraries.size()]);
    }

    public Library[] getOptionalLibraries() {
        ArrayList<Library> libraries = new ArrayList<Library>();
        int i = 0;
        while (i < this.optionalLibraries.size()) {
            OptionalLibraryHolder holder = (OptionalLibraryHolder)this.optionalLibraries.get(i);
            Library l = holder.getLibrary();
            if (l != null) {
                libraries.add(l);
            }
            ++i;
        }
        return libraries.toArray(new Library[libraries.size()]);
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setInfo(String info) {
        super.setInfo(info);
    }

    public void setLicenceName(String licence) {
        super.setLicenceName(licence);
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void setVersion(String version) {
        super.setVersion(version);
    }

    private static class OptionalLibraryHolder {
        private String libraryClass;
        private transient Library library;

        public OptionalLibraryHolder(String libraryClass) {
            if (libraryClass == null) {
                throw new NullPointerException("LibraryClass must not be null.");
            }
            this.libraryClass = libraryClass;
        }

        public OptionalLibraryHolder(Library library) {
            if (library == null) {
                throw new NullPointerException("Library must not be null.");
            }
            this.library = library;
            this.libraryClass = library.getClass().getName();
        }

        public Library getLibrary() {
            block3: {
                if (this.library != null) break block3;
                try {
                    Class<?> maybeLibrary = Class.forName(this.libraryClass);
                    if (maybeLibrary instanceof Library) {
                        this.library = (Library)((Object)maybeLibrary);
                    }
                }
                catch (Exception exception) {}
            }
            return this.library;
        }

        public String getLibraryClass() {
            return this.libraryClass;
        }
    }
}

