/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.contexts.AbstractEntityBeanCollection;
import org.jboss.seam.contexts.PassivatedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityBeanMap
extends AbstractEntityBeanCollection {
    private static final long serialVersionUID = -2884601453783925804L;
    private Map map;
    private Map<Object, PassivatedEntity> passivatedEntityMap;

    public EntityBeanMap(Map instance) {
        this.map = instance;
    }

    @Override
    protected Iterable<PassivatedEntity> getPassivatedEntities() {
        return this.passivatedEntityMap.values();
    }

    @Override
    protected Object getEntityCollection() {
        return this.map;
    }

    @Override
    protected void clearPassivatedEntities() {
        this.passivatedEntityMap = null;
    }

    @Override
    protected boolean isPassivatedEntitiesInitialized() {
        return this.passivatedEntityMap != null;
    }

    @Override
    protected void activateAll() {
        for (Map.Entry<Object, PassivatedEntity> me : this.passivatedEntityMap.entrySet()) {
            this.map.put(me.getKey(), me.getValue().toEntityReference(true));
        }
        this.clearPassivatedEntities();
    }

    @Override
    protected void passivateAll() {
        HashMap<Object, PassivatedEntity> newPassivatedMap = new HashMap<Object, PassivatedEntity>(this.map.size());
        boolean found = false;
        for (Map.Entry me : this.map.entrySet()) {
            PassivatedEntity passivatedEntity;
            Object value = me.getValue();
            if (value == null || (passivatedEntity = PassivatedEntity.passivateEntity(value)) == null) continue;
            if (!found) {
                this.map = new HashMap(this.map);
                found = true;
            }
            this.map.remove(me.getKey());
            newPassivatedMap.put(me.getKey(), passivatedEntity);
        }
        if (found) {
            this.passivatedEntityMap = newPassivatedMap;
        }
    }
}

