/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;

@Scope(value=ScopeType.SESSION)
@Name(value="org.jboss.seam.web.session")
@BypassInterceptors
@Startup
public class Session
extends AbstractMutable {
    private boolean isInvalid;
    private boolean invalidateOnSchemeChange;
    private String currentScheme;

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public void invalidate() {
        this.isInvalid = true;
        this.setDirty();
    }

    public boolean isInvalidDueToNewScheme(String requestScheme) {
        if (this.invalidateOnSchemeChange) {
            if (this.currentScheme == null) {
                this.currentScheme = requestScheme;
                this.setDirty();
                return false;
            }
            if (!this.currentScheme.equals(requestScheme)) {
                this.currentScheme = requestScheme;
                this.setDirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isInvalidateOnSchemeChange() {
        return this.invalidateOnSchemeChange;
    }

    public void setInvalidateOnSchemeChange(boolean invalidateOnSchemeChange) {
        this.setDirty();
        this.invalidateOnSchemeChange = invalidateOnSchemeChange;
    }

    public static Session instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (Session)Component.getInstance(Session.class, ScopeType.SESSION);
    }

    public static Session getInstance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (Session)Component.getInstance(Session.class, ScopeType.SESSION, false);
    }
}

