/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi;

import java.util.Vector;
import org.apache.juddi.IRegistry;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.request.AddPublisherAssertions;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteBinding;
import org.apache.juddi.datatype.request.DeleteBusiness;
import org.apache.juddi.datatype.request.DeletePublisher;
import org.apache.juddi.datatype.request.DeletePublisherAssertions;
import org.apache.juddi.datatype.request.DeleteService;
import org.apache.juddi.datatype.request.DeleteTModel;
import org.apache.juddi.datatype.request.DiscardAuthToken;
import org.apache.juddi.datatype.request.FindBinding;
import org.apache.juddi.datatype.request.FindBusiness;
import org.apache.juddi.datatype.request.FindPublisher;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.request.FindRelatedBusinesses;
import org.apache.juddi.datatype.request.FindService;
import org.apache.juddi.datatype.request.FindTModel;
import org.apache.juddi.datatype.request.GetAssertionStatusReport;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.request.GetBindingDetail;
import org.apache.juddi.datatype.request.GetBusinessDetail;
import org.apache.juddi.datatype.request.GetBusinessDetailExt;
import org.apache.juddi.datatype.request.GetPublisherAssertions;
import org.apache.juddi.datatype.request.GetPublisherDetail;
import org.apache.juddi.datatype.request.GetRegisteredInfo;
import org.apache.juddi.datatype.request.GetRegistryInfo;
import org.apache.juddi.datatype.request.GetServiceDetail;
import org.apache.juddi.datatype.request.GetTModelDetail;
import org.apache.juddi.datatype.request.SaveBinding;
import org.apache.juddi.datatype.request.SaveBusiness;
import org.apache.juddi.datatype.request.SavePublisher;
import org.apache.juddi.datatype.request.SaveService;
import org.apache.juddi.datatype.request.SaveTModel;
import org.apache.juddi.datatype.request.SetPublisherAssertions;
import org.apache.juddi.datatype.request.ValidateValues;
import org.apache.juddi.datatype.response.AssertionStatusReport;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.BusinessDetailExt;
import org.apache.juddi.datatype.response.BusinessList;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.PublisherAssertions;
import org.apache.juddi.datatype.response.PublisherDetail;
import org.apache.juddi.datatype.response.PublisherList;
import org.apache.juddi.datatype.response.RegisteredInfo;
import org.apache.juddi.datatype.response.RegistryInfo;
import org.apache.juddi.datatype.response.RelatedBusinessesList;
import org.apache.juddi.datatype.response.ServiceDetail;
import org.apache.juddi.datatype.response.ServiceList;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.error.RegistryException;

public abstract class AbstractRegistry
implements IRegistry {
    public DispositionReport addPublisherAssertions(AuthInfo authInfo, Vector assertionVector) throws RegistryException {
        AddPublisherAssertions request = new AddPublisherAssertions();
        request.setAuthInfo(authInfo);
        request.setPublisherAssertionVector(assertionVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport deleteBinding(AuthInfo authInfo, Vector bindingKeyVector) throws RegistryException {
        DeleteBinding request = new DeleteBinding();
        request.setAuthInfo(authInfo);
        request.setBindingKeyVector(bindingKeyVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport deleteBusiness(AuthInfo authInfo, Vector businessKeyVector) throws RegistryException {
        DeleteBusiness request = new DeleteBusiness();
        request.setAuthInfo(authInfo);
        request.setBusinessKeyVector(businessKeyVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport deletePublisher(AuthInfo authInfo, Vector publisherIDVector) throws RegistryException {
        DeletePublisher request = new DeletePublisher();
        request.setAuthInfo(authInfo);
        request.setPublisherIDVector(publisherIDVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport deletePublisherAssertions(AuthInfo authInfo, Vector assertionVector) throws RegistryException {
        DeletePublisherAssertions request = new DeletePublisherAssertions();
        request.setAuthInfo(authInfo);
        request.setPublisherAssertionVector(assertionVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport deleteService(AuthInfo authInfo, Vector serviceKeyVector) throws RegistryException {
        DeleteService request = new DeleteService();
        request.setAuthInfo(authInfo);
        request.setServiceKeyVector(serviceKeyVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport deleteTModel(AuthInfo authInfo, Vector tModelKeyVector) throws RegistryException {
        DeleteTModel request = new DeleteTModel();
        request.setAuthInfo(authInfo);
        request.setTModelKeyVector(tModelKeyVector);
        return (DispositionReport)this.execute(request);
    }

    public DispositionReport discardAuthToken(AuthInfo authInfo) throws RegistryException {
        DiscardAuthToken request = new DiscardAuthToken();
        request.setAuthInfo(authInfo);
        return (DispositionReport)this.execute(request);
    }

    public BindingDetail findBinding(String serviceKey, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindBinding request = new FindBinding();
        request.setServiceKey(serviceKey);
        request.setCategoryBag(categoryBag);
        request.setTModelBag(tModelBag);
        request.setFindQualifiers(findQualifiers);
        request.setMaxRows(maxRows);
        return (BindingDetail)this.execute(request);
    }

    public BusinessList findBusiness(Vector nameVector, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindBusiness request = new FindBusiness();
        request.setNameVector(nameVector);
        request.setDiscoveryURLs(discoveryURLs);
        request.setIdentifierBag(identifierBag);
        request.setCategoryBag(categoryBag);
        request.setTModelBag(tModelBag);
        request.setFindQualifiers(findQualifiers);
        request.setMaxRows(maxRows);
        return (BusinessList)this.execute(request);
    }

    public PublisherList findPublisher(String publisherID, String name, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindPublisher request = new FindPublisher();
        request.setName(name);
        request.setFindQualifiers(findQualifiers);
        request.setMaxRows(maxRows);
        return (PublisherList)this.execute(request);
    }

    public RelatedBusinessesList findRelatedBusinesses(String businessKey, KeyedReference keyedReference, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindRelatedBusinesses request = new FindRelatedBusinesses();
        request.setBusinessKey(businessKey);
        request.setKeyedReference(keyedReference);
        request.setFindQualifiers(findQualifiers);
        request.setMaxRows(maxRows);
        return (RelatedBusinessesList)this.execute(request);
    }

    public ServiceList findService(String businessKey, Vector nameVector, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindService request = new FindService();
        request.setBusinessKey(businessKey);
        request.setNameVector(nameVector);
        request.setCategoryBag(categoryBag);
        request.setTModelBag(tModelBag);
        request.setFindQualifiers(findQualifiers);
        request.setMaxRows(maxRows);
        return (ServiceList)this.execute(request);
    }

    public TModelList findTModel(String name, CategoryBag categoryBag, IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindTModel request = new FindTModel();
        request.setName(name);
        request.setCategoryBag(categoryBag);
        request.setIdentifierBag(identifierBag);
        request.setFindQualifiers(findQualifiers);
        request.setMaxRows(maxRows);
        return (TModelList)this.execute(request);
    }

    public AssertionStatusReport getAssertionStatusReport(AuthInfo authInfo, String completionStatus) throws RegistryException {
        GetAssertionStatusReport request = new GetAssertionStatusReport();
        request.setAuthInfo(authInfo);
        request.setCompletionStatus(completionStatus);
        return (AssertionStatusReport)this.execute(request);
    }

    public AuthToken getAuthToken(String userID, String cred) throws RegistryException {
        GetAuthToken request = new GetAuthToken();
        request.setUserID(userID);
        request.setCredential(cred);
        return (AuthToken)this.execute(request);
    }

    public BindingDetail getBindingDetail(String bindingKey) throws RegistryException {
        Vector<String> keys = new Vector<String>(1);
        keys.addElement(bindingKey);
        return this.getBindingDetail(keys);
    }

    public BindingDetail getBindingDetail(Vector bindingKeys) throws RegistryException {
        GetBindingDetail request = new GetBindingDetail();
        request.setBindingKeyVector(bindingKeys);
        return (BindingDetail)this.execute(request);
    }

    public BusinessDetail getBusinessDetail(String businessKey) throws RegistryException {
        Vector<String> keys = new Vector<String>(1);
        keys.addElement(businessKey);
        return this.getBusinessDetail(keys);
    }

    public BusinessDetail getBusinessDetail(Vector businessKeyVector) throws RegistryException {
        GetBusinessDetail request = new GetBusinessDetail();
        request.setBusinessKeyVector(businessKeyVector);
        return (BusinessDetail)this.execute(request);
    }

    public BusinessDetailExt getBusinessDetailExt(String businessKey) throws RegistryException {
        Vector<String> keys = new Vector<String>(1);
        keys.addElement(businessKey);
        return this.getBusinessDetailExt(keys);
    }

    public BusinessDetailExt getBusinessDetailExt(Vector businessKeyVector) throws RegistryException {
        GetBusinessDetailExt request = new GetBusinessDetailExt();
        request.setBusinessKeyVector(businessKeyVector);
        return (BusinessDetailExt)this.execute(request);
    }

    public PublisherAssertions getPublisherAssertions(AuthInfo authInfo) throws RegistryException {
        GetPublisherAssertions request = new GetPublisherAssertions();
        request.setAuthInfo(authInfo);
        return (PublisherAssertions)this.execute(request);
    }

    public PublisherDetail getPublisherDetail(Vector publisherIDVector) throws RegistryException {
        GetPublisherDetail request = new GetPublisherDetail();
        request.setPublisherIDVector(publisherIDVector);
        return (PublisherDetail)this.execute(request);
    }

    public RegisteredInfo getRegisteredInfo(AuthInfo authInfo) throws RegistryException {
        GetRegisteredInfo request = new GetRegisteredInfo();
        request.setAuthInfo(authInfo);
        return (RegisteredInfo)this.execute(request);
    }

    public RegistryInfo getRegistryInfo() throws RegistryException {
        GetRegistryInfo request = new GetRegistryInfo();
        return (RegistryInfo)this.execute(request);
    }

    public ServiceDetail getServiceDetail(String serviceKey) throws RegistryException {
        Vector<String> keys = new Vector<String>(1);
        keys.addElement(serviceKey);
        return this.getServiceDetail(keys);
    }

    public ServiceDetail getServiceDetail(Vector serviceKeyVector) throws RegistryException {
        GetServiceDetail request = new GetServiceDetail();
        request.setServiceKeyVector(serviceKeyVector);
        return (ServiceDetail)this.execute(request);
    }

    public TModelDetail getTModelDetail(String tModelKey) throws RegistryException {
        Vector<String> keys = new Vector<String>(1);
        keys.addElement(tModelKey);
        return this.getTModelDetail(keys);
    }

    public TModelDetail getTModelDetail(Vector tModelKeyVector) throws RegistryException {
        GetTModelDetail request = new GetTModelDetail();
        request.setTModelKeyVector(tModelKeyVector);
        return (TModelDetail)this.execute(request);
    }

    public BindingDetail saveBinding(AuthInfo authInfo, Vector bindingVector) throws RegistryException {
        SaveBinding request = new SaveBinding();
        request.setAuthInfo(authInfo);
        request.setBindingTemplateVector(bindingVector);
        return (BindingDetail)this.execute(request);
    }

    public BusinessDetail saveBusiness(AuthInfo authInfo, Vector businessVector) throws RegistryException {
        SaveBusiness request = new SaveBusiness();
        request.setAuthInfo(authInfo);
        request.setBusinessEntityVector(businessVector);
        return (BusinessDetail)this.execute(request);
    }

    public PublisherDetail savePublisher(AuthInfo authInfo, Vector publisherVector) throws RegistryException {
        SavePublisher request = new SavePublisher();
        request.setAuthInfo(authInfo);
        request.setPublisherVector(publisherVector);
        return (PublisherDetail)this.execute(request);
    }

    public ServiceDetail saveService(AuthInfo authInfo, Vector serviceVector) throws RegistryException {
        SaveService request = new SaveService();
        request.setAuthInfo(authInfo);
        request.setServiceVector(serviceVector);
        return (ServiceDetail)this.execute(request);
    }

    public TModelDetail saveTModel(AuthInfo authInfo, Vector tModelVector) throws RegistryException {
        SaveTModel request = new SaveTModel();
        request.setAuthInfo(authInfo);
        request.setTModelVector(tModelVector);
        return (TModelDetail)this.execute(request);
    }

    public PublisherAssertions setPublisherAssertions(AuthInfo authInfo, Vector assertionVector) throws RegistryException {
        SetPublisherAssertions request = new SetPublisherAssertions();
        request.setAuthInfo(authInfo);
        request.setPublisherAssertionVector(assertionVector);
        return (PublisherAssertions)this.execute(request);
    }

    public DispositionReport validateValues(Vector businessVector, Vector serviceVector, Vector tModelVector) throws RegistryException {
        ValidateValues request = new ValidateValues();
        request.setBusinessEntityVector(businessVector);
        request.setBusinessServiceVector(serviceVector);
        request.setTModelVector(tModelVector);
        return (DispositionReport)this.execute(request);
    }
}

