/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.BusinessKey;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.request.FindRelatedBusinesses;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindRelatedBusinessesHandler
extends AbstractHandler {
    public static final String TAG_NAME = "find_relatedBusinesses";
    private HandlerMaker maker = null;

    protected FindRelatedBusinessesHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String maxRows;
        FindRelatedBusinesses obj = new FindRelatedBusinesses();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((maxRows = element.getAttribute("maxRows")) != null && maxRows.length() > 0) {
            obj.setMaxRows(maxRows);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "businessKey")).size() > 0) {
            handler = this.maker.lookup("businessKey");
            obj.setBusinessKey((BusinessKey)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "findQualifiers")).size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            obj.setFindQualifiers((FindQualifiers)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "keyedReference")).size() > 0) {
            handler = this.maker.lookup("keyedReference");
            obj.setKeyedReference((KeyedReference)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        KeyedReference keyedRef;
        BusinessKey businessKey;
        FindQualifiers qualifiers;
        int maxRows;
        FindRelatedBusinesses request = (FindRelatedBusinesses)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((maxRows = request.getMaxRows()) > 0) {
            element.setAttribute("maxRows", String.valueOf(maxRows));
        }
        if ((qualifiers = request.getFindQualifiers()) != null && qualifiers.size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            handler.marshal(qualifiers, element);
        }
        if ((businessKey = new BusinessKey(request.getBusinessKey())) != null) {
            handler = this.maker.lookup("businessKey");
            handler.marshal(businessKey, element);
        }
        if ((keyedRef = request.getKeyedReference()) != null) {
            handler = this.maker.lookup("keyedReference");
            handler.marshal(keyedRef, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        FindRelatedBusinesses request = new FindRelatedBusinesses();
        request.setBusinessKey("10ad2903-932f-49fe-aaed-bf80d0ed50f0");
        request.addFindQualifier(new FindQualifier("sortByDateAsc"));
        request.addFindQualifier(new FindQualifier("andAllKeys"));
        request.setMaxRows(43);
        request.setKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "catBagKeyName2", "catBagKeyValue2"));
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

