/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.Mac;

import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.tree.DefaultMutableTreeNode;
import net.atomique.ksar.AllGraph;
import net.atomique.ksar.GraphDescription;
import net.atomique.ksar.kSar;
import net.atomique.ksar.kSarConfig;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class pginSar
extends AllGraph {
    private TimeSeries t_pgin;
    private TimeSeries t_pflt;
    private TimeSeries t_vflt;

    public pginSar(kSar hissar) {
        super(hissar);
        this.Title = new String("Page In");
        this.t_pgin = new TimeSeries((Comparable)((Object)"pgin/s"), Second.class);
        this.mysar.dispo.put("Page in/s", this.t_pgin);
        this.t_pflt = new TimeSeries((Comparable)((Object)"pflt/s"), Second.class);
        this.mysar.dispo.put("Page fault/s", this.t_pflt);
        this.t_vflt = new TimeSeries((Comparable)((Object)"vflt/s"), Second.class);
        this.mysar.dispo.put("Page vfault/s", this.t_vflt);
    }

    public void add(Second now, Float val1Init, Float val2Init, Float val3Init) {
        this.t_pgin.add((RegularTimePeriod)now, (Number)val1Init);
        this.t_pflt.add((RegularTimePeriod)now, (Number)val2Init);
        this.t_vflt.add((RegularTimePeriod)now, (Number)val3Init);
    }

    public XYDataset createin() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.t_pgin);
        return timeseriescollection;
    }

    public XYDataset createflt() {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        timeseriescollection.addSeries(this.t_pflt);
        timeseriescollection.addSeries(this.t_vflt);
        return timeseriescollection;
    }

    public void addtotree(DefaultMutableTreeNode myroot) {
        this.mynode = new DefaultMutableTreeNode(new GraphDescription(this, "MACPGIN", this.Title, null));
        this.mysar.add2tree(myroot, this.mynode);
    }

    public JFreeChart makegraph(Second g_start, Second g_end) {
        XYDataset inset = this.createin();
        StandardXYItemRenderer minichart2 = new StandardXYItemRenderer();
        minichart2.setSeriesPaint(0, (Paint)kSarConfig.color1);
        minichart2.setBaseStroke((Stroke)kSarConfig.DEFAULT_STROKE);
        XYPlot subplot2 = new XYPlot(inset, null, (ValueAxis)new NumberAxis("pgin/s"), (XYItemRenderer)minichart2);
        XYDataset fltset = this.createflt();
        StandardXYItemRenderer minichart3 = new StandardXYItemRenderer();
        minichart3.setSeriesPaint(0, (Paint)kSarConfig.color2);
        minichart3.setSeriesPaint(1, (Paint)kSarConfig.color3);
        minichart3.setBaseStroke((Stroke)kSarConfig.DEFAULT_STROKE);
        XYPlot subplot3 = new XYPlot(fltset, null, (ValueAxis)new NumberAxis("pflt/vflt /s"), (XYItemRenderer)minichart3);
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new DateAxis(""));
        plot.add(subplot2, 1);
        plot.add(subplot3, 1);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart jfreechart = new JFreeChart(this.getGraphTitle(), kSarConfig.DEFAULT_FONT, (Plot)plot, true);
        if (g_start != null) {
            DateAxis dateaxis1 = (DateAxis)jfreechart.getXYPlot().getDomainAxis();
            dateaxis1.setRange(g_start.getStart(), g_end.getEnd());
        }
        return jfreechart;
    }
}

