/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.rmi;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.io.IOException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;

public class ConnectionNotifier
extends NotificationBroadcasterSupport {
    private JMXConnector connector;
    private static SynchronizedLong sequenceNumber = new SynchronizedLong(0L);

    public ConnectionNotifier(JMXConnector connector) {
        this.connector = connector;
    }

    public void fireConnectedNotification() {
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.opened", this.connector, this.getConnectionId(), sequenceNumber.increment(), "JMXConnector connected", null);
        this.sendNotification(notification);
    }

    private String getConnectionId() {
        String id = null;
        try {
            id = this.connector.getConnectionId();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return id;
    }

    public void fireClosedNotification() {
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.closed", this.connector, this.getConnectionId(), sequenceNumber.increment(), "JMXConnector closed", null);
        this.sendNotification(notification);
    }
}

