/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import org.jboss.ha.singleton.HASingletonProfileActivatorMBean;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;

public class HASingletonProfileActivator
implements HASingletonProfileActivatorMBean {
    public static final String DEFAULT_PROFILE_NAME = "deploy-hasingleton";
    protected final Logger log = Logger.getLogger(this.getClass());
    private boolean activated;
    private String profileDomain;
    private String profileServer;
    private String profileName;
    private ProfileKey profileKey;
    private ProfileService profileService;

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        if (profileService == null) {
            throw new IllegalArgumentException("profileService is null");
        }
        this.profileService = profileService;
    }

    public String getProfileDomain() {
        return this.profileDomain;
    }

    public void setProfileDomain(String profileDomain) {
        this.profileDomain = profileDomain;
    }

    public String getProfileServer() {
        return this.profileServer;
    }

    public void setProfileServer(String profileServer) {
        this.profileServer = profileServer;
    }

    public String getProfileName() {
        return this.profileName == null ? DEFAULT_PROFILE_NAME : this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public synchronized void activateProfile() throws Exception {
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure the ProfileService");
        }
        if (!this.activated) {
            try {
                this.profileService.activateProfile(this.getProfileKey());
                this.profileService.validateProfile(this.getProfileKey());
                this.activated = true;
            }
            catch (NoSuchProfileException e) {
                this.handleNoSuchProfileException(e);
            }
        }
    }

    public synchronized void releaseProfile() throws Exception {
        if (this.activated) {
            try {
                this.profileService.deactivateProfile(this.getProfileKey());
            }
            catch (NoSuchProfileException e) {
                this.log.warn((Object)("No Profile is registered under key " + this.getProfileKey()));
            }
            this.activated = false;
        }
    }

    public ProfileKey getProfileKey() {
        if (this.profileKey == null) {
            this.profileKey = new ProfileKey(this.getProfileDomain(), this.getProfileServer(), this.getProfileName());
        }
        return this.profileKey;
    }

    protected void handleNoSuchProfileException(NoSuchProfileException e) {
        this.log.warn((Object)("No Profile has been registered under key " + this.getProfileKey() + " -- perhaps you have a deployed deploy-hasingleton-jboss-beans.xml " + " without any corresponding profile configured?"));
    }
}

