/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Pipe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeSinkChannelImpl
implements StreamSinkChannel {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.pipe.sink-channel");
    private final Pipe.SinkChannel channel;
    private final NioHandle handle;
    private final NioXnio nioXnio;
    private final IoHandler<? super StreamSinkChannel> handler;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final AtomicLong bytes;
    private final AtomicLong messages;
    private final Closeable mbeanHandle;

    public NioPipeSinkChannelImpl(Pipe.SinkChannel channel, IoHandler<? super StreamSinkChannel> handler, NioXnio nioXnio, AtomicLong bytes, AtomicLong messages, Closeable mbeanHandle) throws IOException {
        this.channel = channel;
        this.handler = handler;
        this.nioXnio = nioXnio;
        this.bytes = bytes;
        this.messages = messages;
        this.mbeanHandle = mbeanHandle;
        this.handle = nioXnio.addWriteHandler(channel, new Handler());
    }

    public int write(ByteBuffer dst) throws IOException {
        int ret = this.channel.write(dst);
        if (ret > 0) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public long write(ByteBuffer[] dsts) throws IOException {
        long ret = this.channel.write(dsts);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public long write(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.channel.write(dsts, offset, length);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            HandlerUtils.handleClosed(this.handler, this);
            this.nioXnio.removeManaged((Closeable)((Object)this));
            IoUtils.safeClose((Closeable)this.mbeanHandle);
            this.channel.close();
        }
    }

    public void suspendWrites() {
        try {
            this.handle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.handle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownWrites() throws IOException {
        this.channel.close();
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 4, time, timeUnit);
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public String toString() {
        return String.format("pipe sink channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private final class Handler
    implements Runnable {
        private Handler() {
        }

        public void run() {
            HandlerUtils.handleWritable(NioPipeSinkChannelImpl.this.handler, NioPipeSinkChannelImpl.this);
        }
    }
}

