/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNameVirtualFileFilter
implements VirtualFileFilter {
    private Logger log = Logger.getLogger(this.getClass());
    private Map<String, Set<String>> excludes;

    public FileNameVirtualFileFilter(Map<String, Set<String>> excludes) {
        if (excludes == null || excludes.isEmpty()) {
            throw new IllegalArgumentException("Null or empty excludes.");
        }
        this.excludes = excludes;
    }

    public boolean accepts(VirtualFile file) {
        String pathName = file.getPathName();
        for (Map.Entry<String, Set<String>> entry : this.excludes.entrySet()) {
            String key = entry.getKey();
            if (!pathName.contains(key)) continue;
            String simpleName = file.getName();
            Set<String> value = entry.getValue();
            if (value != null && !value.contains(simpleName)) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Excluding " + pathName));
            }
            return false;
        }
        return true;
    }
}

