/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.management.ObjectName;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.InstancePoolContainer;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.LocalProxyFactory;
import org.jboss.ejb.MessageDrivenContainerMBean;
import org.jboss.ejb.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.security.SecurityContext;
import org.jboss.util.NullArgumentException;
import org.jboss.util.UnreachableStatementException;

public class MessageDrivenContainer
extends Container
implements EJBProxyFactoryContainer,
InstancePoolContainer,
MessageDrivenContainerMBean {
    protected Map beanMapping;
    protected InstancePool instancePool;
    protected Interceptor interceptor;
    protected long messageCount;

    public LocalProxyFactory getLocalProxyFactory() {
        return this.localProxyFactory;
    }

    public void setInstancePool(InstancePool instancePool) {
        if (instancePool == null) {
            throw new NullArgumentException("instancePool");
        }
        this.instancePool = instancePool;
    }

    public InstancePool getInstancePool() {
        return this.instancePool;
    }

    public void addInterceptor(Interceptor in) {
        if (this.interceptor == null) {
            this.interceptor = in;
        } else {
            Interceptor current = this.interceptor;
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(in);
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public Class getHomeClass() {
        return null;
    }

    public Class getRemoteClass() {
        return null;
    }

    public Class getLocalClass() {
        return null;
    }

    public Class getLocalHomeClass() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            super.createService();
            HashMap<Method, Method> map = new HashMap<Method, Method>();
            MessageDrivenMetaData mdMetaData = (MessageDrivenMetaData)this.metaData;
            String type = mdMetaData.getMessagingType();
            if (type == null || type.length() == 0) {
                type = "javax.jms.MessageListener";
            }
            Class<?> clazz = this.getClassLoader().loadClass(type);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                map.put(m, this.beanClass.getMethod(m.getName(), m.getParameterTypes()));
                this.log.debug((Object)("Mapped " + m.getName() + " " + m.hashCode() + " to " + map.get(m)));
            }
            if (TimedObject.class.isAssignableFrom(this.beanClass)) {
                map.put(TimedObject.class.getMethod("ejbTimeout", Timer.class), this.beanClass.getMethod("ejbTimeout", Timer.class));
            }
            this.beanMapping = map;
            try {
                ObjectName containerName = super.getJmxName();
                Hashtable<String, String> props = containerName.getKeyPropertyList();
                props.put("plugin", "pool");
                ObjectName poolName = new ObjectName(containerName.getDomain(), props);
                this.server.registerMBean(this.instancePool, poolName);
            }
            catch (Throwable t) {
                this.log.debug((Object)"Failed to register pool as mbean", t);
            }
            this.instancePool.setContainer(this);
            this.instancePool.create();
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                try {
                    ObjectName containerName = super.getJmxName();
                    Hashtable<String, String> props = containerName.getKeyPropertyList();
                    props.put("plugin", "invoker");
                    props.put("binding", invokerBinding);
                    ObjectName invokerName = new ObjectName(containerName.getDomain(), props);
                    this.server.registerMBean(ci, invokerName);
                }
                catch (Throwable t) {
                    this.log.debug((Object)"Failed to register invoker binding as mbean", t);
                }
                ci.create();
            }
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.setContainer(this);
                in.create();
            }
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            super.startService();
            this.instancePool.start();
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.start();
            }
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.start();
            }
            this.restoreTimers();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            super.stopService();
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.stop();
            }
            this.instancePool.stop();
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.stop();
            }
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.destroy();
                try {
                    ObjectName containerName = super.getJmxName();
                    Hashtable<String, String> props = containerName.getKeyPropertyList();
                    props.put("plugin", "invoker");
                    props.put("binding", invokerBinding);
                    ObjectName invokerName = new ObjectName(containerName.getDomain(), props);
                    this.server.unregisterMBean(invokerName);
                }
                catch (Throwable ignore) {}
            }
            this.instancePool.destroy();
            this.instancePool.setContainer(null);
            try {
                ObjectName containerName = super.getJmxName();
                Hashtable<String, String> props = containerName.getKeyPropertyList();
                props.put("plugin", "pool");
                ObjectName poolName = new ObjectName(containerName.getDomain(), props);
                this.server.unregisterMBean(poolName);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.destroy();
                in.setContainer(null);
            }
            super.destroyService();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    public Object internalInvokeHome(Invocation mi) throws Exception {
        throw new Error("invokeHome not valid for MessageDriven beans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object internalInvoke(Invocation mi) throws Exception {
        SecurityContext cachedContext = null;
        try {
            cachedContext = SecurityActions.getSecurityContext();
            SecurityActions.setSecurityContext(null);
            Object object = this.getInterceptor().invoke(mi);
            return object;
        }
        finally {
            SecurityActions.setSecurityContext(cachedContext);
        }
    }

    public EJBObject createHome() throws RemoteException, CreateException {
        throw new Error("createHome not valid for MessageDriven beans");
    }

    public void removeHome(Handle handle) throws RemoteException, RemoveException {
        throw new Error("removeHome not valid for MessageDriven beans");
    }

    public void removeHome(Object primaryKey) throws RemoteException, RemoveException {
        throw new Error("removeHome not valid for MessageDriven beans");
    }

    public EJBMetaData getEJBMetaDataHome() throws RemoteException {
        throw new Error("getEJBMetaDataHome not valid for MessageDriven beans");
    }

    public HomeHandle getHomeHandleHome() throws RemoteException {
        throw new Error("getHomeHandleHome not valid for MessageDriven beans");
    }

    Interceptor createContainerInterceptor() {
        return new ContainerInterceptor();
    }

    class ContainerInterceptor
    extends Container.AbstractContainerInterceptor {
        ContainerInterceptor() {
        }

        public Object invokeHome(Invocation mi) throws Exception {
            throw new Error("invokeHome not valid for MessageDriven beans");
        }

        public Object invoke(Invocation mi) throws Exception {
            Method m;
            EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
            if (ctx.getTransaction() == null) {
                ctx.setTransaction(mi.getTransaction());
            }
            if ((m = (Method)MessageDrivenContainer.this.beanMapping.get(mi.getMethod())) == null) {
                String msg = MessageDrivenContainer.this.getBeanMetaData().getEjbName() + " Invalid invocation, check your deployment packaging, interfaces, method=" + mi.getMethod();
                throw new EJBException(msg);
            }
            try {
                ++MessageDrivenContainer.this.messageCount;
                return mi.performCall(ctx.getInstance(), m, mi.getArguments());
            }
            catch (Exception e) {
                this.rethrow(e);
                throw new UnreachableStatementException();
            }
        }
    }
}

