/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jms;

import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.ObjectName;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.KernelAbstractionFactory;
import org.jboss.ejb3.jms.JMSDestinationFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPeerJMSDestinationFactory
extends JMSDestinationFactory {
    private static final Logger log = Logger.getLogger(ServerPeerJMSDestinationFactory.class);

    ServerPeerJMSDestinationFactory() {
    }

    @Override
    public void createDestination(Class<? extends Destination> type, String jndiSuffix) throws Exception {
        String methodName;
        String destinationContext;
        if (type == Topic.class) {
            destinationContext = "topic";
            methodName = "createTopic";
        } else if (type == Queue.class) {
            destinationContext = "queue";
            methodName = "createQueue";
        } else {
            throw new IllegalArgumentException("Expected javax.jms.Queue or javax.jms.Topic: " + type);
        }
        String name = jndiSuffix;
        String jndiName = destinationContext + "/" + jndiSuffix;
        ObjectName serverPeerName = new ObjectName("jboss.messaging:service=ServerPeer");
        KernelAbstraction kernel = KernelAbstractionFactory.getInstance();
        Object result = kernel.invoke(serverPeerName, methodName, new Object[]{name, jndiName}, new String[]{"java.lang.String", "java.lang.String"});
        log.debug((Object)("result = " + result));
    }
}

