/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.DeliveryObserver;
import org.jboss.messaging.core.contract.Distributor;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.Receiver;
import org.jboss.messaging.core.impl.SimpleDelivery;
import org.jboss.messaging.core.impl.tx.Transaction;

public class FirstReceiverDistributor
implements Distributor {
    private static final Logger log = Logger.getLogger(FirstReceiverDistributor.class);
    private boolean trace = log.isTraceEnabled();
    private List receivers = new ArrayList();
    private volatile boolean makeCopy = true;
    private ArrayList receiversCopy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx) {
        if (this.makeCopy) {
            FirstReceiverDistributor firstReceiverDistributor = this;
            synchronized (firstReceiverDistributor) {
                this.receiversCopy = new ArrayList(this.receivers);
                this.makeCopy = false;
            }
        }
        Delivery del = null;
        boolean selectorRejected = false;
        for (Receiver receiver : this.receiversCopy) {
            try {
                Delivery d = receiver.handle(observer, ref, tx);
                if (this.trace) {
                    log.trace((Object)("receiver " + receiver + " handled " + ref + " and returned " + d));
                }
                if (d == null) continue;
                if (d.isSelectorAccepted()) {
                    del = d;
                    break;
                }
                selectorRejected = true;
            }
            catch (Throwable t) {
                log.error((Object)("The receiver " + receiver + " is broken"), t);
            }
        }
        if (del == null && selectorRejected) {
            del = new SimpleDelivery(null, null, false, false);
        }
        return del;
    }

    public synchronized boolean add(Receiver r) {
        if (this.receivers.contains(r)) {
            return false;
        }
        this.receivers.add(r);
        this.makeCopy = true;
        return true;
    }

    public synchronized boolean remove(Receiver r) {
        boolean removed = this.receivers.remove(r);
        if (removed) {
            this.makeCopy = true;
        }
        return removed;
    }

    public synchronized void clear() {
        this.receivers.clear();
        this.makeCopy = true;
    }

    public synchronized boolean contains(Receiver r) {
        return this.receivers.contains(r);
    }

    public synchronized Iterator iterator() {
        return this.receivers.iterator();
    }

    public synchronized int getNumberOfReceivers() {
        return this.receivers.size();
    }
}

