/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.jboss.messaging.util.Streamable;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

class PostOfficeAddressInfo
implements Streamable,
Serializable {
    private static final long serialVersionUID = 8462102430717730566L;
    private Address controlChannelAddress;
    private Address dataChannelAddress;

    PostOfficeAddressInfo() {
    }

    PostOfficeAddressInfo(Address controlChannelAddress, Address dataChannelAddress) {
        this.controlChannelAddress = controlChannelAddress;
        this.dataChannelAddress = dataChannelAddress;
    }

    public void read(DataInputStream in) throws Exception {
        this.controlChannelAddress = new IpAddress();
        this.controlChannelAddress.readFrom(in);
        this.dataChannelAddress = new IpAddress();
        this.dataChannelAddress.readFrom(in);
    }

    public void write(DataOutputStream out) throws Exception {
        if (!(this.controlChannelAddress instanceof IpAddress)) {
            throw new IllegalStateException("Address must be IpAddress");
        }
        if (!(this.dataChannelAddress instanceof IpAddress)) {
            throw new IllegalStateException("Address must be IpAddress");
        }
        this.controlChannelAddress.writeTo(out);
        this.dataChannelAddress.writeTo(out);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append("synch addr ").append(this.controlChannelAddress);
        sb.append(", asynch addr ").append(this.dataChannelAddress);
        sb.append("]");
        return sb.toString();
    }

    Address getControlChannelAddress() {
        return this.controlChannelAddress;
    }

    Address getDataChannelAddress() {
        return this.dataChannelAddress;
    }
}

