/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.dependency.AbstractKernelController;
import org.jboss.kernel.plugins.dependency.AbstractScopeAction;
import org.jboss.kernel.plugins.dependency.ScopeHierarchyBuilder;
import org.jboss.kernel.plugins.dependency.ScopedKernelController;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.ScopeKey;

public class InstallScopeAction
extends AbstractScopeAction {
    public static final InstallScopeAction INSTANCE = new InstallScopeAction();

    protected void installAction(ControllerContext context) throws Throwable {
        ScopeKey scopeKey = this.getScopeKey(context);
        if (scopeKey != null) {
            Controller controller = context.getController();
            if (!(controller instanceof AbstractKernelController)) {
                throw new IllegalArgumentException("Can only handle AbstractKernelController: " + controller);
            }
            AbstractKernelController kernelController = (AbstractKernelController)controller;
            KernelMetaDataRepository repository = kernelController.getKernel().getMetaDataRepository();
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            AbstractController abstractController = ScopeHierarchyBuilder.buildControllerHierarchy(kernelController, mmdr, scopeKey);
            if (!(abstractController instanceof ScopedKernelController)) {
                throw new IllegalArgumentException("Should be ScopedKernelController instance: " + abstractController);
            }
            ScopedKernelController scopedController = (ScopedKernelController)abstractController;
            scopedController.addScopedControllerContext(context);
        }
    }

    protected void uninstallAction(ControllerContext context) {
        ScopeKey scopeKey = this.getScopeKey(context);
        if (scopeKey != null) {
            Controller controller = context.getController();
            if (!(controller instanceof KernelController)) {
                throw new IllegalArgumentException("Can only handle kernel controller: " + controller);
            }
            KernelController kernelController = (KernelController)controller;
            KernelMetaDataRepository repository = kernelController.getKernel().getMetaDataRepository();
            MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
            ScopeHierarchyBuilder.cleanControllerHierarchy(mmdr, scopeKey, context);
        }
    }
}

