/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.security.xacml.interfaces.AbstractLocator;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinderModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLocator
extends AttributeFinderModule
implements AbstractLocator {
    private String identifier = null;
    private boolean attributeDesignatorSupported = true;
    private boolean attributeSelectorSupported = true;
    private Set<Integer> designatorTypes = new HashSet<Integer>();
    private Set<URI> ids = new HashSet<URI>();
    private List<Option> options = new ArrayList<Option>();
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public void setOptions(List<Option> options) {
        this.options = options;
        try {
            this.processOptions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            return super.getIdentifier();
        }
        return this.identifier;
    }

    @Override
    public Set getSupportedDesignatorTypes() {
        return this.designatorTypes;
    }

    @Override
    public Set getSupportedIds() {
        return this.ids;
    }

    @Override
    public boolean isDesignatorSupported() {
        return this.attributeDesignatorSupported;
    }

    @Override
    public boolean isSelectorSupported() {
        return this.attributeSelectorSupported;
    }

    private void processOptions() throws Exception {
        for (Option option : this.options) {
            String tag = option.getName();
            List<Object> values = option.getContent();
            String value = (String)values.get(0);
            if ("identifier".equals(tag)) {
                this.identifier = value;
                continue;
            }
            if ("attributeDesignatorSupport".equals(tag)) {
                this.attributeDesignatorSupported = Boolean.parseBoolean(value);
                continue;
            }
            if ("attributeSelectorSupport".equals(tag)) {
                this.attributeSelectorSupported = Boolean.parseBoolean(value);
                continue;
            }
            if ("attributeSupportedId".equals(tag)) {
                this.ids.add(new URI(value));
                continue;
            }
            if (!"attributeDesignatorInt".equals(tag)) continue;
            this.designatorTypes.add(Integer.parseInt(value));
        }
    }
}

