/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local;

import java.io.File;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.jboss.bootstrap.spi.Server;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.AbstractContentMetadataPersister;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;

public class JAXBRepositoryContentMetadataPersister
extends AbstractContentMetadataPersister {
    private static final Logger log = Logger.getLogger(JAXBRepositoryContentMetadataPersister.class);
    private static final String METADATA_SUFFIX = "-repository-contents.xml";
    private static final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public JAXBRepositoryContentMetadataPersister(Server server) {
        this(server.getConfig().getServerDataDir());
    }

    public JAXBRepositoryContentMetadataPersister(URI uri) {
        this(new File(uri));
    }

    public JAXBRepositoryContentMetadataPersister(File dir) {
        super(dir);
    }

    public File getMetadataPath(String storeName) {
        String vfsPath = storeName + METADATA_SUFFIX;
        return new File(this.getContentMetadataDir(), vfsPath);
    }

    protected RepositoryContentMetadata loadMetadata(File metadataStore) throws Exception {
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        return (RepositoryContentMetadata)unmarshaller.unmarshal(metadataStore.toURL().openStream(), (SchemaBindingResolver)resolver);
    }

    protected void saveMetadata(File metadataStore, RepositoryContentMetadata metadata) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saveMetadata, metadataStore=" + metadataStore + ", metadata=" + metadata));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{metadata.getClass()});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)metadata, metadataStore);
    }

    static {
        resolver.addClassBindingForLocation("repository-content", RepositoryContentMetadata.class);
    }
}

