/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryHandler
extends AbstractVirtualFileHandler
implements StructuredVirtualFileHandler {
    private URL url;
    private boolean isLeaf;
    private transient boolean initialized;

    public ZipEntryHandler(ZipEntryContext context, AbstractVirtualFileHandler parent, String name, boolean isLeaf) throws IOException {
        super(context, parent, name);
        this.isLeaf = isLeaf;
        if (parent != null) {
            context.addChild(parent, this);
        }
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        StringBuilder vfsUrl = new StringBuilder();
        try {
            this.url = this.getZipEntryContext().getChildURL(this.getParent(), this.getName());
            String currentUrl = this.url.toString();
            int pos = currentUrl.indexOf(":/");
            vfsUrl.append("vfszip:").append(currentUrl.substring(pos + 1));
            if (!this.isLeaf && vfsUrl.charAt(vfsUrl.length() - 1) != '/') {
                vfsUrl.append("/");
            }
            this.setVfsUrl(new URL(vfsUrl.toString()));
        }
        catch (Exception ex) {
            throw new RuntimeException("ASSERTION ERROR - failed to set vfsUrl: " + vfsUrl, ex);
        }
        this.initialized = true;
    }

    @Override
    public URI toURI() throws URISyntaxException {
        this.init();
        return VFSUtils.toURI(this.url);
    }

    @Override
    public long getLastModified() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().getLastModified(this);
    }

    @Override
    public long getSize() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().getSize(this);
    }

    @Override
    public boolean exists() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().exists(this);
    }

    @Override
    public boolean isLeaf() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().isLeaf(this);
    }

    @Override
    public boolean isArchive() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().isArchive(this);
    }

    @Override
    public boolean isHidden() throws IOException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean isNested() throws IOException {
        return ZipEntryContext.isNested(this);
    }

    @Override
    public InputStream openStream() throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().openStream(this);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        return this.getZipEntryContext().getChildren(this, ignoreErrors);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        this.checkClosed();
        return this.structuredFindChild(path);
    }

    @Override
    public boolean removeChild(String name) throws IOException {
        return false;
    }

    @Override
    public void cleanup() {
        this.getZipEntryContext().cleanup(this);
    }

    @Override
    public boolean delete(int gracePeriod) throws IOException {
        this.checkClosed();
        boolean deleted = this.getZipEntryContext().delete(this, gracePeriod);
        if (deleted) {
            super.delete(gracePeriod);
        }
        return deleted;
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        return this.getZipEntryContext().getChild(this, name);
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        if (!(original instanceof AbstractVirtualFileHandler)) {
            throw new IllegalArgumentException("Original file handler not found in this context: " + original);
        }
        this.getZipEntryContext().replaceChild(this, (AbstractVirtualFileHandler)original, replacement);
    }

    private ZipEntryContext getZipEntryContext() {
        return (ZipEntryContext)this.getLocalVFSContext();
    }

    @Override
    protected URL toInternalVfsUrl() {
        this.init();
        return super.getVfsUrl();
    }

    @Override
    public URL getRealURL() throws IOException, URISyntaxException {
        VFSContext ctx = this.getLocalVFSContext();
        VirtualFileHandler peer = this.getLocalVFSContext().getRootPeer();
        if (peer == null) {
            URL ctxURL = this.getZipEntryContext().getRealURL();
            String ctxURLStr = ctxURL.toExternalForm();
            if (ctxURLStr.endsWith("!/")) {
                String lpath = this.getLocalPathName();
                if (lpath.startsWith("/")) {
                    lpath = lpath.substring(1);
                }
                if (lpath.length() == 0) {
                    return ctxURL;
                }
                return new URL(ctxURLStr + lpath);
            }
            return ctxURL;
        }
        if (peer instanceof AbstractVirtualFileHandler && ((AbstractVirtualFileHandler)peer).getLocalVFSContext() instanceof FileSystemContext) {
            String lpath = this.getLocalPathName();
            if (!lpath.startsWith("/")) {
                lpath = "/" + lpath;
            }
            return new URL("jar:file:" + ctx.getRootURI().getPath() + "!" + lpath);
        }
        if (peer instanceof AbstractVirtualFileHandler) {
            AbstractVirtualFileHandler aPeer = (AbstractVirtualFileHandler)peer;
            URL realUrl = aPeer.getLocalVFSContext().getRoot().getRealURL();
            String urlStr = realUrl.toExternalForm();
            if (urlStr.endsWith("!/")) {
                return new URL(urlStr + aPeer.getLocalPathName());
            }
            return realUrl;
        }
        throw new RuntimeException("Operation not supported for handler: " + this);
    }
}

