/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.metadata;

import java.io.Closeable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.TcpChannelSource;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.helpers.XnioController;
import org.jboss.xnio.metadata.AbstractConfigurableMetaData;
import org.jboss.xnio.metadata.DestinationMetaData;
import org.jboss.xnio.metadata.InetSocketAddressMetaData;
import org.jboss.xnio.metadata.NamedBeanMetaData;
import org.jboss.xnio.metadata.PipeConnectorMetaData;
import org.jboss.xnio.metadata.TcpChannelSourceMetaData;
import org.jboss.xnio.metadata.TcpConnectorMetaData;
import org.jboss.xnio.metadata.TcpServerMetaData;
import org.jboss.xnio.metadata.UdpServerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XnioMetaDataHelper {
    private static final String DEFAULT_PROVIDER_BEAN_NAME = "XnioProvider";
    private static final AtomicInteger PRIVATE_SEQ = new AtomicInteger(new Random().nextInt());

    private XnioMetaDataHelper() {
    }

    public static SocketAddress[] getBindAddresses(List<InetSocketAddressMetaData> inetSocketAddressMetaDataList) {
        int bindCount = inetSocketAddressMetaDataList.size();
        SocketAddress[] addresses = new SocketAddress[bindCount];
        int i = 0;
        for (InetSocketAddressMetaData metaData : inetSocketAddressMetaDataList) {
            addresses[i++] = metaData.getSocketAddress();
        }
        return addresses;
    }

    public static ValueMetaData createInject(BeanMetaDataBuilder builder, NamedBeanMetaData namedBeanMetaData) {
        return builder.createInject((Object)namedBeanMetaData.getName());
    }

    public static void addConfigProperties(BeanMetaDataBuilder builder, AbstractConfigurableMetaData configData) {
        Boolean tcpNoDelay;
        Integer sendBufferSize;
        Boolean reuseAddress;
        Integer receiveBufferSize;
        Boolean oobInline;
        Integer multicastTtl;
        Boolean manageConnections;
        Boolean keepAlive;
        Integer ipTos;
        Integer ipTrafficClass;
        Boolean closeAbort;
        Boolean broadcast;
        Integer backlog = configData.getBacklog();
        if (backlog != null) {
            builder.addPropertyMetaData("backlog", (Object)backlog);
        }
        if ((broadcast = configData.getBroadcast()) != null) {
            builder.addPropertyMetaData("broadcast", (Object)broadcast);
        }
        if ((closeAbort = configData.getCloseAbort()) != null) {
            builder.addPropertyMetaData("closeAbort", (Object)closeAbort);
        }
        if ((ipTrafficClass = configData.getIpTrafficClass()) != null) {
            builder.addPropertyMetaData("ipTrafficClass", (Object)ipTrafficClass);
        }
        if ((ipTos = configData.getIpTos()) != null) {
            builder.addPropertyMetaData("ipTos", (Object)ipTos);
        }
        if ((keepAlive = configData.getKeepAlive()) != null) {
            builder.addPropertyMetaData("keepAlive", (Object)keepAlive);
        }
        if ((manageConnections = configData.getManageConnections()) != null) {
            builder.addPropertyMetaData("manageConnections", (Object)manageConnections);
        }
        if ((multicastTtl = configData.getMulticastTtl()) != null) {
            builder.addPropertyMetaData("multicastTtl", (Object)multicastTtl);
        }
        if ((oobInline = configData.getOobInline()) != null) {
            builder.addPropertyMetaData("oobInline", (Object)oobInline);
        }
        if ((receiveBufferSize = configData.getReceiveBufferSize()) != null) {
            builder.addPropertyMetaData("receiveBufferSize", (Object)receiveBufferSize);
        }
        if ((reuseAddress = configData.getReuseAddress()) != null) {
            builder.addPropertyMetaData("reuseAddress", (Object)reuseAddress);
        }
        if ((sendBufferSize = configData.getSendBufferSize()) != null) {
            builder.addPropertyMetaData("sendBufferSize", (Object)sendBufferSize);
        }
        if ((tcpNoDelay = configData.getTcpNoDelay()) != null) {
            builder.addPropertyMetaData("tcpNoDelay", (Object)tcpNoDelay);
        }
    }

    public static void add(List<BeanMetaData> list, String provider, PipeConnectorMetaData pipeConnectorMetaData, String createMethodName) {
        String name = pipeConnectorMetaData.getName();
        NamedBeanMetaData executorBean = pipeConnectorMetaData.getExecutorBean();
        NamedBeanMetaData handlerFactoryBean = pipeConnectorMetaData.getHandlerFactoryBean();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Closeable.class.getName());
        if (provider != null) {
            builder.setFactory(builder.createInject((Object)provider));
        } else {
            builder.setFactory(builder.createInject((Object)DEFAULT_PROVIDER_BEAN_NAME));
        }
        builder.setFactoryMethod(createMethodName);
        if (executorBean != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executorBean.getName()));
        }
        builder.addConstructorParameter(IoHandlerFactory.class.getName(), builder.createInject((Object)handlerFactoryBean.getName()));
        builder.setStop("close");
        list.add(builder.getBeanMetaData());
    }

    private static BeanMetaDataBuilder getConfigurableBeanMetaDataBuilder(String provider, AbstractConfigurableMetaData configurableMetaData) {
        String name = configurableMetaData.getName();
        String privateName = name + ":Xnio-private:" + Integer.toHexString(name.hashCode()) + ":" + Integer.toHexString(PRIVATE_SEQ.getAndIncrement());
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)privateName, (String)XnioController.class.getName());
        if (provider != null) {
            builder.addConstructorParameter(Xnio.class.getName(), builder.createInject((Object)provider));
        } else {
            builder.addConstructorParameter(Xnio.class.getName(), builder.createInject((Object)DEFAULT_PROVIDER_BEAN_NAME));
        }
        XnioMetaDataHelper.addConfigProperties(builder, configurableMetaData);
        return builder;
    }

    private static void addPublicAndPrivate(List<BeanMetaData> list, String name, BeanMetaDataBuilder builder) {
        BeanMetaData privateBeanMetaData = builder.getBeanMetaData();
        list.add(privateBeanMetaData);
        BeanMetaDataBuilder publicBuilder = BeanMetaDataBuilder.createBuilder((String)name, (String)BoundServer.class.getName());
        publicBuilder.setFactory((ValueMetaData)privateBeanMetaData);
        publicBuilder.setFactoryMethod("getHandle");
        list.add(publicBuilder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, TcpServerMetaData tcpServerMetaData) {
        String name = tcpServerMetaData.getName();
        NamedBeanMetaData handlerFactoryBean = tcpServerMetaData.getHandlerFactoryBean();
        NamedBeanMetaData executorBean = tcpServerMetaData.getExecutorBean();
        BeanMetaDataBuilder builder = XnioMetaDataHelper.getConfigurableBeanMetaDataBuilder(provider, tcpServerMetaData);
        builder.setFactoryMethod("tcpServer");
        if (executorBean != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executorBean.getName()));
        }
        builder.addConstructorParameter(IoHandlerFactory.class.getName(), builder.createInject((Object)handlerFactoryBean.getName()));
        ArrayList<SocketAddress> socketAddresses = new ArrayList<SocketAddress>();
        for (InetSocketAddressMetaData metaData : tcpServerMetaData.getBindAddresses()) {
            socketAddresses.add(metaData.getSocketAddress());
        }
        builder.addConstructorParameter(SocketAddress[].class.getName(), builder.createValue((Object)socketAddresses.toArray(new SocketAddress[socketAddresses.size()])));
        XnioMetaDataHelper.addPublicAndPrivate(list, name, builder);
    }

    public static void add(List<BeanMetaData> list, String provider, TcpConnectorMetaData tcpConnectorMetaData) {
        String name = tcpConnectorMetaData.getName();
        NamedBeanMetaData executorBean = tcpConnectorMetaData.getExecutorBean();
        BeanMetaDataBuilder builder = XnioMetaDataHelper.getConfigurableBeanMetaDataBuilder(provider, tcpConnectorMetaData);
        builder.setFactoryMethod("tcpConnector");
        if (executorBean != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executorBean.getName()));
        }
        XnioMetaDataHelper.addPublicAndPrivate(list, name, builder);
    }

    public static void add(List<BeanMetaData> list, String provider, UdpServerMetaData udpServerMetaData) {
        String name = udpServerMetaData.getName();
        NamedBeanMetaData handlerFactoryBean = udpServerMetaData.getHandlerFactoryBean();
        NamedBeanMetaData executorBean = udpServerMetaData.getExecutorBean();
        BeanMetaDataBuilder builder = XnioMetaDataHelper.getConfigurableBeanMetaDataBuilder(provider, udpServerMetaData);
        builder.setFactoryMethod("udpServer");
        if (executorBean != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executorBean.getName()));
        }
        Boolean multicast = udpServerMetaData.getMulticast();
        builder.addConstructorParameter(Boolean.TYPE.getName(), builder.createValue((Object)(multicast == null ? Boolean.FALSE : multicast)));
        builder.addConstructorParameter(IoHandlerFactory.class.getName(), builder.createInject((Object)handlerFactoryBean.getName()));
        ArrayList<SocketAddress> socketAddresses = new ArrayList<SocketAddress>();
        for (InetSocketAddressMetaData metaData : udpServerMetaData.getBindAddresses()) {
            socketAddresses.add(metaData.getSocketAddress());
        }
        builder.addConstructorParameter(SocketAddress[].class.getName(), builder.createValue((Object)socketAddresses.toArray(new SocketAddress[socketAddresses.size()])));
        XnioMetaDataHelper.addPublicAndPrivate(list, name, builder);
    }

    public static void add(List<BeanMetaData> list, TcpChannelSourceMetaData tcpChannelSourceMetaData) {
        String name = tcpChannelSourceMetaData.getName();
        DestinationMetaData destination = tcpChannelSourceMetaData.getDestination();
        NamedBeanMetaData connectorBean = tcpChannelSourceMetaData.getTcpConnectorBean();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)TcpChannelSource.class.getName());
        builder.setFactory(builder.createInject((Object)connectorBean.getName()));
        builder.setFactoryMethod("createChannelSource");
        InetSocketAddressMetaData src = destination.getBindAddress();
        InetSocketAddressMetaData dest = destination.getConnectAddress();
        if (src != null) {
            builder.addConstructorParameter(SocketAddress.class.getName(), (Object)src.getSocketAddress());
        }
        builder.addConstructorParameter(SocketAddress.class.getName(), (Object)dest.getSocketAddress());
        list.add(builder.getBeanMetaData());
    }
}

