/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static RunAs getCallerRunAsIdentity() {
        return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                RunAs rai = null;
                SecurityContext existingSC = SecurityActions.getSecurityContext();
                if (existingSC != null) {
                    rai = existingSC.getOutgoingRunAs();
                }
                return rai;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext createSecurityContext(final Principal p, final Object cred, final String sdomain) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, null, (String)sdomain);
            }
        });
    }

    static void setIncomingRunAs(final SecurityContext sc, final RunAs incomingRunAs) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setOutgoingRunAs(incomingRunAs);
                return null;
            }
        });
    }

    static void setOutgoingRunAs(final SecurityContext sc, final RunAs outgoingRunAs) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setOutgoingRunAs(outgoingRunAs);
                return null;
            }
        });
    }
}

