/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.SessionBean;
import org.jboss.management.j2ee.StatelessSessionBeanMBean;
import org.jboss.management.j2ee.statistics.RangeStatisticImpl;
import org.jboss.management.j2ee.statistics.StatelessSessionBeanStatsImpl;

public class StatelessSessionBean
extends SessionBean
implements StatelessSessionBeanMBean {
    private static Logger log = Logger.getLogger(StatelessSessionBean.class);
    private StatelessSessionBeanStatsImpl stats = new StatelessSessionBeanStatsImpl();

    public StatelessSessionBean(String name, ObjectName ejbModuleName, ObjectName ejbContainerName) throws MalformedObjectNameException, InvalidParentException {
        this(name, ejbModuleName, ejbContainerName, null, null);
    }

    public StatelessSessionBean(String name, ObjectName ejbModuleName, ObjectName ejbContainerName, String jndiName, String localJndiName) throws MalformedObjectNameException, InvalidParentException {
        super("StatelessSessionBean", name, ejbModuleName, ejbContainerName, jndiName, localJndiName);
    }

    public Stats getstats() {
        try {
            this.updateCommonStats(this.stats);
            ObjectName poolName = this.getContainerPoolName();
            RangeStatisticImpl readyCount = (RangeStatisticImpl)this.stats.getMethodReadyCount();
            Integer poolSize = (Integer)this.server.getAttribute(poolName, "CurrentSize");
            readyCount.set(poolSize.longValue());
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String toString() {
        return "StatelessSessionBean { " + super.toString() + " } []";
    }
}

