/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import javassist.scopedpool.ScopedClassPoolFactory;
import javax.management.Notification;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectNotificationHandler;
import org.jboss.aop.ClassLoaderValidation;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.asintegration.core.AspectManagerServiceDelegate;
import org.jboss.aop.deployment.AbstractAspectManagerServiceMBean;
import org.jboss.aop.deployment.JBossIntegrationWrapperMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class AbstractAspectManagerService
extends ServiceMBeanSupport
implements AbstractAspectManagerServiceMBean,
AspectNotificationHandler {
    Logger log = Logger.getLogger(AbstractAspectManagerService.class);
    private static final String BASE_XML = "base-aop.xml";
    private AspectManagerServiceDelegate delegate;

    public AbstractAspectManagerService() {
        this.delegate = this.createDelegate();
        this.delegate.setBaseXml(BASE_XML);
        this.delegate.setAspectManager(AspectManager.getTopLevelAspectManager());
        this.delegate.setAspectManagerMaintainAdvisorInterceptors(true);
        this.delegate.setUseBaseXml(true);
    }

    public AbstractAspectManagerService(AspectManagerServiceDelegate delegate) {
        this.delegate = delegate;
    }

    protected AspectManagerServiceDelegate createDelegate() {
        throw new RuntimeException("Should not use this class directly");
    }

    public void setJBossIntegrationWrapper(JBossIntegrationWrapperMBean integration) {
        JBossIntegration intgr = integration != null ? integration.getIntegration() : null;
        this.delegate.setJBossIntegration(intgr);
    }

    protected ScopedClassPoolFactory createFactory() throws Exception {
        return this.delegate.createFactory();
    }

    protected ClassLoaderValidation createClassLoaderValidation() {
        return this.delegate.createClassLoaderValidation();
    }

    protected void createService() throws Exception {
        this.delegate.create();
        AspectManager.notificationHandler = this;
    }

    protected void destroyService() throws Exception {
        this.delegate.destroy();
    }

    protected void startService() throws Exception {
        this.delegate.start();
    }

    protected void stopService() throws Exception {
        this.delegate.stop();
    }

    public void attachClass(String classname) {
        Notification msg = new Notification("AOP class attached", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(classname);
        this.sendNotification(msg);
    }

    public boolean getPrune() {
        return this.delegate.getPrune();
    }

    public void setPrune(boolean prune) {
        this.delegate.setPrune(prune);
    }

    public String getExclude() {
        return this.delegate.getExclude();
    }

    public void setExclude(String exclude) {
        this.delegate.setExclude(exclude);
    }

    public String getInclude() {
        return this.delegate.getInclude();
    }

    public void setInclude(String include) {
        this.delegate.setInclude(include);
    }

    public String getIgnore() {
        return this.delegate.getIgnore();
    }

    public void setIgnore(String ignore) {
        this.delegate.setIgnore(ignore);
    }

    public String getIncludedInvisibleAnnotations() {
        return this.delegate.getIncludedInvisibleAnnotations();
    }

    public void setIncludedInvisibleAnnotations(String ia) {
        this.delegate.setIncludedInvisibleAnnotations(ia);
    }

    public File getTmpClassesDir() {
        return this.delegate.getTmpClassesDir();
    }

    public void setTmpClassesDir(File tmpClassesDir) {
        this.delegate.setTmpClassesDir(tmpClassesDir);
    }

    public boolean getVerbose() {
        return this.delegate.getVerbose();
    }

    public void setVerbose(boolean verbose) {
        this.delegate.setVerbose(verbose);
    }

    public boolean getOptimized() {
        return this.delegate.getOptimized();
    }

    public void setOptimized(boolean verbose) {
        this.delegate.setOptimized(verbose);
    }

    public boolean getSuppressTransformationErrors() {
        return this.delegate.getSuppressReferenceErrors();
    }

    public void setSuppressTransformationErrors(boolean suppressTransformationErrors) {
        this.delegate.setSuppressTransformationErrors(suppressTransformationErrors);
    }

    public boolean getSuppressReferenceErrors() {
        return this.delegate.getSuppressReferenceErrors();
    }

    public void setSuppressReferenceErrors(boolean suppressReferenceErrors) {
        this.delegate.setSuppressReferenceErrors(suppressReferenceErrors);
    }

    public boolean getEnableTransformer() {
        return this.delegate.getEnableTransformer();
    }

    public String interceptorFactories() {
        return this.delegate.interceptorFactories();
    }

    public String aspectDefinitions() {
        return this.delegate.aspectDefinitions();
    }

    public String introductions() {
        return this.delegate.introductions();
    }

    public String stacks() {
        return this.delegate.stacks();
    }

    public String bindings() {
        return this.delegate.bindings();
    }

    public String pointcuts() {
        return this.delegate.pointcuts();
    }

    public String registeredClassLoaders() {
        return this.delegate.registeredClassLoaders();
    }

    public void setEnableTransformer(boolean enableTransformer) {
        this.delegate.setEnableTransformer(enableTransformer);
    }

    public boolean getEnableLoadtimeWeaving() {
        return this.delegate.getEnableLoadtimeWeaving();
    }

    public void setEnableLoadtimeWeaving(boolean enableTransformer) {
        this.delegate.setEnableLoadtimeWeaving(enableTransformer);
    }

    public String getInstrumentor() {
        return this.delegate.getInstrumentor();
    }

    public void setInstrumentor(String instrumentor) {
        this.delegate.setInstrumentor(instrumentor);
    }

    public boolean getUseBaseXml() {
        return this.delegate.getUseBaseXml();
    }

    public synchronized void setUseBaseXml(boolean useBaseXml) {
        this.delegate.setUseBaseXml(useBaseXml);
    }
}

