/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.services.binding.ServiceBindingMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingSet {
    private static final long serialVersionUID = 765380451233486038L;
    private final String bindingSetName;
    private String defaultHostName;
    private int portOffset;
    private final Set<ServiceBindingMetadata> overrides = new HashSet<ServiceBindingMetadata>(0);

    public ServiceBindingSet(String name) {
        this(name, null, 0, null);
    }

    public ServiceBindingSet(String name, Set<ServiceBindingMetadata> overrides) {
        this(name, null, 0, overrides);
    }

    public ServiceBindingSet(String name, int offset) {
        this(name, null, offset, null);
    }

    public ServiceBindingSet(String name, String defaultHostName, int offset) {
        this(name, defaultHostName, offset, null);
    }

    public ServiceBindingSet(String name, String defaultHostName, int offset, Set<ServiceBindingMetadata> overrides) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.bindingSetName = name;
        this.defaultHostName = defaultHostName;
        this.portOffset = offset;
        if (overrides != null) {
            for (ServiceBindingMetadata sbm : overrides) {
                this.overrides.add(sbm);
            }
        }
    }

    public String getName() {
        return this.bindingSetName;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public Set<ServiceBindingMetadata> getOverrideBindings() {
        Set<ServiceBindingMetadata> result = this.overrides == null ? Collections.EMPTY_SET : this.overrides;
        return result;
    }
}

