/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.File;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.file.AbstractLocalContentChangeAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;

public class RemoveFileAction
extends AbstractLocalContentChangeAction {
    private static final Logger log = Logger.getLogger(RemoveFileAction.class);

    public RemoveFileAction(File targetFile, FileBasedSynchronizationActionContext context, ContentModification modification) {
        super(targetFile, context, modification);
    }

    protected boolean modifyTarget() throws IOException {
        File target = this.getTargetFile();
        return !target.exists() || target.delete();
    }

    protected Logger getLogger() {
        return log;
    }

    protected void doRollbackFromPrepared() {
        if (!this.getRepositoryContentModification().getItem().isDirectory()) {
            super.doRollbackFromPrepared();
        }
    }

    protected void doRollbackFromRollbackOnly() {
        if (!this.getRepositoryContentModification().getItem().isDirectory()) {
            super.doRollbackFromRollbackOnly();
        }
    }

    protected void updateContentMetadata() {
        ContentModification mod = this.getRepositoryContentModification();
        RepositoryItemMetadata modItem = mod.getItem();
        if (modItem.isRemoved()) {
            super.updateContentMetadata();
        } else if (mod.getType() == ContentModification.Type.REMOVE_FROM_CLUSTER) {
            RepositoryContentMetadata contentMetadata = ((FileBasedSynchronizationActionContext)this.getContext()).getInProgressMetadata();
            RepositoryRootMetadata rmd = contentMetadata.getRepositoryRootMetadata(mod.getRootName());
            rmd.removeItemMetadata(modItem.getRelativePathElements());
        } else {
            RepositoryItemMetadata markedRemoved = RemoveFileAction.getMarkedRemovedItem(mod);
            RepositoryContentMetadata contentMetadata = ((FileBasedSynchronizationActionContext)this.getContext()).getInProgressMetadata();
            RepositoryRootMetadata rmd = contentMetadata.getRepositoryRootMetadata(mod.getRootName());
            rmd.addItemMetadata(markedRemoved);
        }
    }
}

