/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.List;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.microcontainer.beans.BindingEntry;
import org.jboss.aop.microcontainer.beans.InterceptorEntry;
import org.jboss.aop.microcontainer.beans.Stack;

public class StackEntry
extends BindingEntry {
    Stack stack;
    List<InterceptorEntry> advices;
    InterceptorFactory[] factories;

    public Stack getStack() {
        return this.stack;
    }

    public void setStack(Stack stack) {
        this.stack = stack;
    }

    public InterceptorFactory[] getInterceptorFactories() {
        return this.factories;
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.binding == null) {
            throw new IllegalArgumentException("Null aspect binding");
        }
        if (this.stack == null) {
            throw new IllegalArgumentException("Null stack");
        }
        this.advices = this.stack.getClonedAdvices(this.binding);
        if (this.advices == null) {
            throw new IllegalArgumentException("Null advices");
        }
        this.factories = new InterceptorFactory[this.advices.size()];
        int i = 0;
        for (InterceptorEntry entry : this.advices) {
            entry.start();
            this.factories[i++] = entry.getInterceptorFactory();
        }
    }

    public void stop() {
        this.advices = null;
        this.factories = null;
    }
}

