/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.remoting.transport.socket.SocketClientInvoker;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class SSLSocketClientInvoker
extends SocketClientInvoker {
    private static final Logger log = Logger.getLogger((Class)SSLSocketClientInvoker.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    protected String[] enabledCipherSuites;
    protected String[] enabledProtocols;
    protected boolean enableSessionCreation = true;

    public SSLSocketClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.debug((Object)"Error setting up ssl socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public SSLSocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.debug((Object)"Error setting up ssl socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setOOBInline(boolean inline) {
        log.warn((Object)"Ignored: sending urgent data is not supported by SSLSockets");
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        this.enableSessionCreation = enableSessionCreation;
    }

    protected void setup() throws Exception {
        super.setup();
        Object o = this.configuration.get("enabledCipherSuites");
        if (o instanceof String[]) {
            this.setEnabledCipherSuites((String[])o);
        }
        if ((o = this.configuration.get("enabledProtocols")) instanceof String[]) {
            this.setEnabledProtocols((String[])o);
        }
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (SSLSocketClientInvoker.isCompleteSocketFactory(sf)) {
            return sf;
        }
        SocketFactory wrapper = sf;
        try {
            SSLSocketBuilder server = new SSLSocketBuilder(configuration);
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            log.error((Object)("Error creating SSL Socket Factory for client invoker: " + e.getMessage()));
            log.debug((Object)"Error creating SSL Socket Factory for client invoker.", (Throwable)e);
        }
        if (wrapper != null) {
            ((SocketFactoryWrapper)((Object)wrapper)).setSocketFactory(sf);
            this.socketFactory = wrapper;
            return wrapper;
        }
        return sf;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Object obj;
        SocketFactory sf = this.getSocketFactory();
        if (sf == null) {
            sf = this.createSocketFactory(this.configuration);
        }
        Socket s = sf.createSocket();
        this.configureSocket(s);
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        SSLSocketClientInvoker.connect(s, inetAddr, timeout);
        if (s instanceof SSLSocket && (obj = this.configuration.get("handshakeCompletedListener")) != null && obj instanceof HandshakeCompletedListener) {
            SSLSocket sslSocket = (SSLSocket)s;
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            this.establishHandshake(sslSocket, listener);
        }
        return s;
    }

    protected void configureSocket(Socket s) throws SocketException {
        s.setReuseAddress(this.getReuseAddress());
        if (this.keepAliveSet) {
            s.setKeepAlive(this.keepAlive);
        }
        if (this.receiveBufferSize > -1) {
            s.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize > -1) {
            s.setSendBufferSize(this.sendBufferSize);
        }
        if (this.soLingerSet && this.soLingerDuration > 0) {
            s.setSoLinger(this.soLinger, this.soLingerDuration);
        }
        if (this.trafficClass > -1) {
            s.setTrafficClass(this.trafficClass);
        }
        if (s instanceof SSLSocket) {
            SSLSocket ss = (SSLSocket)s;
            if (this.enabledCipherSuites != null) {
                ss.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                ss.setEnabledProtocols(this.enabledProtocols);
            }
            ss.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener(repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }

    private static void connect(final Socket socket, final InetSocketAddress address, final int timeout) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            socket.connect(address, timeout);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    socket.connect(address, timeout);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

