/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.util.Stack;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.login.Configuration;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.security.auth.login.XMLLoginConfig;
import org.jboss.security.plugins.SecurityConfigMBean;
import org.jboss.system.ServiceMBeanSupport;

@JMX(name="jboss.security:service=SecurityConfig", exposedInterface=SecurityConfigMBean.class)
@ManagementObject(name="SecurityConfig", componentType=@ManagementComponent(type="MCBean", subtype="Security"), properties=ManagementProperties.EXPLICIT)
public class SecurityConfig
extends ServiceMBeanSupport
implements SecurityConfigMBean {
    private String loginConfigName;
    private XMLLoginConfig defaultLoginConfig;
    private final Stack<Configuration> loginConfigStack = new Stack();
    private MBeanServer mbeanServer;

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The default Configuration bean name")
    public String getLoginConfig() {
        return this.loginConfigName;
    }

    public void setLoginConfig(String name) throws MalformedObjectNameException {
        this.loginConfigName = name;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The MBean server")
    public MBeanServer getMbeanServer() {
        if (this.mbeanServer == null) {
            return super.getServer();
        }
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The default login config bean")
    public XMLLoginConfig getDefaultLoginConfig() {
        return this.defaultLoginConfig;
    }

    public void setDefaultLoginConfig(XMLLoginConfig defaultLoginConfig) {
        this.defaultLoginConfig = defaultLoginConfig;
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void startService() throws Exception {
        if (this.defaultLoginConfig != null) {
            this.pushLoginConfig(this.defaultLoginConfig);
        } else {
            this.pushLoginConfig(this.loginConfigName);
        }
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void stopService() throws Exception {
        if (!this.loginConfigStack.empty()) {
            this.popLoginConfig();
        }
    }

    public synchronized void pushLoginConfig(XMLLoginConfig loginConfig) {
        Configuration prevConfig = null;
        if (!this.loginConfigStack.empty()) {
            prevConfig = this.loginConfigStack.peek();
        }
        Configuration configuration = loginConfig.getConfiguration(prevConfig);
        Configuration.setConfiguration(configuration);
        this.loginConfigStack.push(configuration);
        this.log.debug((Object)("Installed JAAS configuration: " + configuration));
    }

    @ManagementOperation(description="Install the Configuration from the MBean identified by objectName", params={@ManagementParameter(name="objectName", description="The identifier of the MBean that contains the Configuration")}, impact=ManagedOperation.Impact.WriteOnly)
    public synchronized void pushLoginConfig(String objectName) throws JMException, MalformedObjectNameException {
        ObjectName name = new ObjectName(objectName);
        Configuration prevConfig = null;
        if (!this.loginConfigStack.empty()) {
            prevConfig = this.loginConfigStack.peek();
        }
        this.loginConfigStack.push(this.installConfig(name, prevConfig));
    }

    @ManagementOperation(description="Uninstall the current Configuration", impact=ManagedOperation.Impact.WriteOnly)
    public synchronized void popLoginConfig() throws JMException {
        this.loginConfigStack.pop();
        if (!this.loginConfigStack.empty()) {
            Configuration.setConfiguration(this.loginConfigStack.peek());
        }
    }

    private Configuration installConfig(ObjectName name, Configuration prevConfig) throws JMException {
        Object[] args = new Object[]{prevConfig};
        String[] signature = new String[]{"javax.security.auth.login.Configuration"};
        Configuration config = (Configuration)this.getMbeanServer().invoke(name, "getConfiguration", args, signature);
        Configuration.setConfiguration(config);
        this.log.debug((Object)("Installed JAAS Configuration service=" + name + ", config=" + config));
        return config;
    }

    public String getName() {
        return "SecurityIntialization";
    }
}

