/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool;

import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.pool.Pool;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPool
implements Pool {
    private static final Logger log = Logger.getLogger(AbstractPool.class);
    protected Injector[] injectors;
    protected Container container;
    protected int createCount = 0;
    protected int removeCount = 0;

    @Override
    public int getCreateCount() {
        return this.createCount;
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount;
    }

    @Override
    public void initialize(Container container, int maxSize, long timeout) {
        assert (container != null) : "container is null";
        this.container = container;
    }

    @Override
    public abstract void setMaxSize(int var1);

    @Deprecated
    protected BeanContext<?> create() {
        return this.create(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanContext<?> create(Class[] initTypes, Object[] initValues) {
        BeanContext ctx = this.createBeanContext();
        this.container.pushContext(ctx);
        try {
            this.container.injectBeanContext(ctx);
            ctx.initialiseInterceptorInstances();
        }
        finally {
            this.container.popContext();
        }
        this.container.invokePostConstruct(ctx, initValues);
        this.container.invokeInit(ctx.getInstance(), initTypes, initValues);
        ++this.createCount;
        return ctx;
    }

    private BeanContext createBeanContext() {
        return this.container.createBeanContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BeanContext ctx) {
        try {
            this.container.invokePreDestroy(ctx);
        }
        finally {
            ctx.remove();
            ++this.removeCount;
        }
    }

    @Override
    public void discard(BeanContext<?> ctx) {
        this.remove((BeanContext)ctx);
    }

    @Override
    public void setInjectors(Injector[] injectors) {
        this.injectors = injectors;
    }
}

