/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.net.URL;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.profileservice.management.FilteredDeploymentTemplateInfo;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.virtual.VirtualFile;

public class AbstractTemplateCreator {
    private DeploymentManager deploymentMgr;
    private ProfileKey defaultKey = new ProfileKey("default");

    public DeploymentManager getDeploymentManager() {
        return this.deploymentMgr;
    }

    public void setDeploymentManager(DeploymentManager deploymentMgr) {
        this.deploymentMgr = deploymentMgr;
    }

    public ProfileKey getDefaulProfiletKey() {
        return this.defaultKey;
    }

    public void setDefaultProfileKey(ProfileKey defaultKey) {
        this.defaultKey = defaultKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String applyTemplate(DeploymentTemplate template, String deploymentBaseName, DeploymentTemplateInfo info) throws Exception {
        if (template == null) {
            throw new IllegalArgumentException("Null deployment template.");
        }
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null deployment name.");
        }
        if ((deploymentBaseName = deploymentBaseName.trim()).length() == 0) {
            throw new IllegalArgumentException("emtpy deployment base name");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null deployment template info.");
        }
        this.deploymentMgr.loadProfile(this.defaultKey);
        VirtualFile base = null;
        String[] repositoryNames = null;
        try {
            String deploymentName = template.getDeploymentName(deploymentBaseName);
            if (deploymentName == null) {
                throw new IllegalStateException("getDeploymentName returned a null value.");
            }
            FilteredDeploymentTemplateInfo filterInfo = new FilteredDeploymentTemplateInfo(info);
            base = template.applyTemplate((DeploymentTemplateInfo)filterInfo);
            if (base == null) {
                throw new IllegalStateException("applyTemplate returned null virtual file.");
            }
            try {
                repositoryNames = this.distribute(deploymentName, base.toURL());
            }
            catch (Exception e) {
                try {
                    if (repositoryNames != null) {
                        this.remove(repositoryNames);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw e;
            }
            try {
                this.start(repositoryNames);
            }
            catch (Exception e) {
                try {
                    this.stop(repositoryNames);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    this.remove(repositoryNames);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw e;
            }
        }
        finally {
            this.deploymentMgr.releaseProfile();
            if (base != null) {
                base.delete();
            }
        }
        return repositoryNames[0];
    }

    protected String[] distribute(String name, URL url) throws Exception {
        DeploymentProgress progress = this.deploymentMgr.distribute(name, url, true);
        progress.run();
        this.checkComplete(progress);
        return progress.getDeploymentID().getRepositoryNames();
    }

    protected void start(String[] names) throws Exception {
        DeploymentProgress progress = this.deploymentMgr.start(names);
        progress.run();
        this.checkComplete(progress);
    }

    protected void stop(String[] names) throws Exception {
        DeploymentProgress progress = this.deploymentMgr.stop(names);
        progress.run();
        this.checkComplete(progress);
    }

    protected void remove(String[] names) throws Exception {
        DeploymentProgress progress = this.deploymentMgr.remove(names);
        progress.run();
        this.checkComplete(progress);
    }

    protected void checkComplete(DeploymentProgress progress) throws Exception {
        if (progress.getDeploymentStatus().isFailed()) {
            throw new RuntimeException("Failed to process template.", progress.getDeploymentStatus().getFailure());
        }
    }
}

