/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.io.Serializable;
import org.jboss.monitor.EntityLockMonitor;

public class LockMonitor
implements Serializable {
    private static final long serialVersionUID = -6710878502772579272L;
    private long totalTime;
    private long numContentions;
    private long timeouts;
    private long maxContenders;
    private long currentContenders;
    private transient EntityLockMonitor parent;

    public LockMonitor(EntityLockMonitor parent) {
        this.parent = parent;
    }

    public synchronized long getTotalTime() {
        return this.totalTime;
    }

    public synchronized long getNumContentions() {
        return this.numContentions;
    }

    public synchronized long getTimeouts() {
        return this.timeouts;
    }

    public synchronized long getMaxContenders() {
        return this.maxContenders;
    }

    public synchronized long getCurrentContenders() {
        return this.currentContenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contending() {
        LockMonitor lockMonitor = this;
        synchronized (lockMonitor) {
            ++this.numContentions;
            ++this.currentContenders;
            if (this.currentContenders > this.maxContenders) {
                this.maxContenders = this.currentContenders;
            }
        }
        if (this.parent != null) {
            this.parent.incrementContenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedContending(long time) {
        LockMonitor lockMonitor = this;
        synchronized (lockMonitor) {
            this.totalTime += time;
            --this.currentContenders;
        }
        if (this.parent != null) {
            this.parent.decrementContenders(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseTimeouts() {
        LockMonitor lockMonitor = this;
        synchronized (lockMonitor) {
            ++this.timeouts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LockMonitor lockMonitor = this;
        synchronized (lockMonitor) {
            this.timeouts = 0L;
            this.totalTime = 0L;
            this.numContentions = 0L;
            this.maxContenders = this.currentContenders;
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(128);
        sbuf.append(super.toString()).append("[ ").append("totalTime=").append(this.getTotalTime()).append(", numContentions=").append(this.getNumContentions()).append(", timeouts=").append(this.getTimeouts()).append(", maxContenders=").append(this.getMaxContenders()).append(", currentContenders=").append(this.getCurrentContenders()).append(" ]");
        return sbuf.toString();
    }
}

