/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.ws.scout.registry.infomodel.ExtensibleObjectImpl;
import org.apache.ws.scout.registry.infomodel.ExternalIdentifierImpl;
import org.apache.ws.scout.registry.infomodel.ExternalLinkImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;

public class RegistryObjectImpl
extends ExtensibleObjectImpl
implements RegistryObject {
    private final LifeCycleManager lifeCycleManager;
    private Key key;
    private InternationalString name = new InternationalStringImpl();
    private InternationalString desc = new InternationalStringImpl();
    private Set classifications = new HashSet();
    private Set associations = new HashSet();
    private Set externalIds = new HashSet();
    private Set externalLinks = new HashSet();
    private OrganizationImpl submittingOrganization;

    public RegistryObjectImpl(LifeCycleManager lifeCycleManager) {
        this.lifeCycleManager = lifeCycleManager;
    }

    public RegistryObjectImpl(LifeCycleManager lifeCycleManager, InternationalString n) {
        this.lifeCycleManager = lifeCycleManager;
        this.name = n;
    }

    public Key getKey() {
        return this.key;
    }

    public InternationalString getDescription() {
        return this.desc;
    }

    public void setDescription(InternationalString description) {
        this.desc = description;
    }

    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString name) {
        this.name = name;
    }

    public void setKey(Key k) {
        this.key = k;
    }

    public String toXML() throws JAXRException {
        throw new UnsupportedCapabilityException("toXML is not supported");
    }

    public void addClassification(Classification classification) {
        this.classifications.add(classification);
    }

    public void addClassifications(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Classification classification = (Classification)i.next();
            this.classifications.add(classification);
        }
    }

    public void removeClassification(Classification classification) {
        this.classifications.remove(classification);
    }

    public void removeClassifications(Collection collection) {
        this.classifications.removeAll(collection);
    }

    public Collection getClassifications() {
        return Collections.unmodifiableSet(this.classifications);
    }

    public void setClassifications(Collection collection) {
        HashSet<Classification> newClassifications = new HashSet<Classification>(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Classification classification = (Classification)i.next();
            newClassifications.add(classification);
        }
        this.classifications = newClassifications;
    }

    public void addAssociation(Association association) throws JAXRException {
        this.associations.add(association);
        association.setSourceObject((RegistryObject)this);
    }

    public void addAssociations(Collection collection) throws JAXRException {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            this.addAssociation(association);
        }
    }

    public Collection getAssociations() throws JAXRException {
        return Collections.unmodifiableSet(this.associations);
    }

    public void setAssociations(Collection collection) {
        HashSet<Association> newAssociations = new HashSet<Association>(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            newAssociations.add(association);
        }
        this.associations = newAssociations;
    }

    public void removeAssociation(Association association) {
        this.associations.remove(association);
    }

    public void removeAssociations(Collection collection) {
        this.associations.removeAll(collection);
    }

    public void addExternalIdentifier(ExternalIdentifier externalIdentifier) {
        this.externalIds.add(externalIdentifier);
        ((ExternalIdentifierImpl)externalIdentifier).setRegistryObject(this);
    }

    public void addExternalIdentifiers(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            ExternalIdentifier externalId = (ExternalIdentifier)i.next();
            this.externalIds.add(externalId);
            ((ExternalIdentifierImpl)externalId).setRegistryObject(this);
        }
    }

    public void removeExternalIdentifier(ExternalIdentifier externalIdentifier) {
        this.externalIds.remove(externalIdentifier);
        ((ExternalIdentifierImpl)externalIdentifier).setRegistryObject(null);
    }

    public void removeExternalIdentifiers(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter != null && iter.hasNext()) {
            ExternalIdentifier externalId = (ExternalIdentifier)iter.next();
            ((ExternalIdentifierImpl)externalId).setRegistryObject(null);
        }
        this.externalIds.removeAll(collection);
    }

    public Collection getExternalIdentifiers() {
        return Collections.unmodifiableSet(this.externalIds);
    }

    public void setExternalIdentifiers(Collection collection) {
        HashSet<ExternalIdentifier> newExternalIds = new HashSet<ExternalIdentifier>(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            ExternalIdentifier externalId = (ExternalIdentifier)i.next();
            newExternalIds.add(externalId);
        }
        this.externalIds = newExternalIds;
    }

    public void addExternalLink(ExternalLink externalLink) {
        this.externalLinks.add(externalLink);
        ((ExternalLinkImpl)externalLink).addLinkedObject(this);
    }

    public void addExternalLinks(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            ExternalLink externalLink = (ExternalLink)i.next();
            this.externalLinks.add(externalLink);
            ((ExternalLinkImpl)externalLink).addLinkedObject(this);
        }
    }

    public void removeExternalLink(ExternalLink externalLink) {
        ((ExternalLinkImpl)externalLink).removeLinkedObject(this);
        this.externalLinks.remove(externalLink);
    }

    public void removeExternalLinks(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter != null && iter.hasNext()) {
            ExternalLink externalLink = (ExternalLink)iter.next();
            ((ExternalLinkImpl)externalLink).removeLinkedObject(this);
        }
        this.externalLinks.removeAll(collection);
    }

    public Collection getExternalLinks() {
        return Collections.unmodifiableSet(this.externalLinks);
    }

    public void setExternalLinks(Collection collection) {
        HashSet<ExternalLink> newExternalLinks = new HashSet<ExternalLink>(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            ExternalLink externalLink = (ExternalLink)i.next();
            newExternalLinks.add(externalLink);
        }
        this.externalLinks = newExternalLinks;
    }

    public Organization getSubmittingOrganization() {
        return this.submittingOrganization;
    }

    public LifeCycleManager getLifeCycleManager() {
        return this.lifeCycleManager;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RegistryObjectImpl other = (RegistryObjectImpl)obj;
        return this.key != null && this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key == null ? 0 : this.key.hashCode();
    }

    public Collection getAuditTrail() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public Collection getAssociatedObjects() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public Concept getObjectType() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public Collection getRegistryPackages() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }
}

