/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging.jakarta;

import com.arjuna.common.internal.util.logging.AbstractLogInterface;
import com.arjuna.common.internal.util.logging.LogFactoryInterface;
import com.arjuna.common.internal.util.logging.jakarta.JakartaLogger;
import com.arjuna.common.internal.util.logging.jakarta.Log4JLogger;
import com.arjuna.common.util.exceptions.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class JakartaLogFactory
implements LogFactoryInterface {
    public AbstractLogInterface getLog(Class clazz) throws LogConfigurationException {
        Object oldConfig = null;
        try {
            oldConfig = this.configureFactory();
            JakartaLogger jakartaLogger = new JakartaLogger(LogFactory.getLog((Class)clazz));
            return jakartaLogger;
        }
        catch (org.apache.commons.logging.LogConfigurationException lce) {
            throw new LogConfigurationException(lce.getMessage());
        }
        finally {
            this.resetFactory(oldConfig);
        }
    }

    public AbstractLogInterface getLog(String name) throws LogConfigurationException {
        Object oldConfig = null;
        try {
            oldConfig = this.configureFactory();
            JakartaLogger jakartaLogger = new JakartaLogger(LogFactory.getLog((String)name));
            return jakartaLogger;
        }
        catch (org.apache.commons.logging.LogConfigurationException lce) {
            throw new LogConfigurationException(lce.getMessage());
        }
        finally {
            this.resetFactory(oldConfig);
        }
    }

    private Object configureFactory() {
        Object oldValue = LogFactory.getFactory().getAttribute("org.apache.commons.logging.Log");
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)Log4JLogger.class.getName());
        return oldValue;
    }

    private void resetFactory(Object value) {
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", value);
    }
}

