/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static Subject getActiveSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static void setContextClassLoader(ClassLoader loader) {
        SetTCLAction action = new SetTCLAction(loader);
        AccessController.doPrivileged(action);
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static SecurityContext createSecurityContext(final String domain) throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)domain);
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void clearSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    static void setSecurityContext(SecurityContext sc) {
        SetSecurityContextAction action = new SetSecurityContextAction(sc);
        AccessController.doPrivileged(action);
    }

    static class SetSecurityContextAction
    implements PrivilegedAction {
        private SecurityContext securityContext;

        SetSecurityContextAction(SecurityContext sc) {
            this.securityContext = sc;
        }

        public Object run() {
            SecurityContextAssociation.setSecurityContext((SecurityContext)this.securityContext);
            return null;
        }
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityActions.getSecurityContext().getUtil().createSubjectInfo(principal, credential, subject);
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityContext sc = SecurityActions.getSecurityContext();
                        if (sc != null) {
                            sc.getUtil().createSubjectInfo(null, null, null);
                        }
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityActions.getSecurityContext().getUtil().createSubjectInfo(principal, credential, subject);
            }

            public void pop() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    sc.getUtil().createSubjectInfo(null, null, null);
                }
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void pop();
    }

    private static class SetTCLAction
    implements PrivilegedAction {
        ClassLoader loader;

        SetTCLAction(ClassLoader loader) {
            this.loader = loader;
        }

        public Object run() {
            Thread.currentThread().setContextClassLoader(this.loader);
            this.loader = null;
            return null;
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }
}

