/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;

public abstract class BaseClassLoaderSystem {
    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{");
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    protected void registerDomain(BaseClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        domain.setClassLoaderSystem(this);
    }

    protected void unregisterDomain(BaseClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        domain.setClassLoaderSystem(null);
    }

    protected ClassLoader registerClassLoaderPolicy(final BaseClassLoaderDomain domain, final ClassLoaderPolicy policy) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        return AccessController.doPrivileged(new PrivilegedAction<BaseClassLoader>(){

            @Override
            public BaseClassLoader run() {
                BaseClassLoader classLoader = BaseClassLoaderSystem.this.createClassLoader(policy);
                BaseClassLoaderSystem.this.beforeRegisterClassLoader(classLoader);
                domain.registerClassLoader(classLoader);
                BaseClassLoaderSystem.this.afterRegisterClassLoader(classLoader);
                return classLoader;
            }
        }, policy.getAccessControlContext());
    }

    protected void unregisterClassLoaderPolicy(ClassLoaderPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        ClassLoaderPolicy basePolicy = policy;
        BaseClassLoader classLoader = basePolicy.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Policy has no associated classloader, it is therefore not registered with a domain. " + policy.toLongString());
        }
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        if (domain == null) {
            throw new IllegalStateException("Policy has no domain " + policy.toLongString());
        }
        this.beforeUnregisterClassLoader(classLoader);
        domain.unregisterClassLoader(classLoader);
        this.afterUnregisterClassLoader(classLoader);
    }

    protected void unregisterClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classLoader");
        }
        if (!(classLoader instanceof BaseClassLoader)) {
            throw new IllegalStateException("ClassLoader is not the correct type and therefore not registered: " + classLoader);
        }
        BaseClassLoader baseClassLoader = (BaseClassLoader)classLoader;
        this.unregisterClassLoaderPolicy(baseClassLoader.getPolicy());
    }

    protected BaseClassLoader createClassLoader(ClassLoaderPolicy policy) {
        return new BaseClassLoader(policy);
    }

    protected void beforeRegisterClassLoader(ClassLoader classLoader) {
    }

    protected void afterRegisterClassLoader(ClassLoader classLoader) {
    }

    protected void beforeUnregisterClassLoader(ClassLoader classLoader) {
    }

    protected void afterUnregisterClassLoader(ClassLoader classLoader) {
    }

    protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        return byteCode;
    }
}

