/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.factory;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.Servlet;
import org.jboss.management.j2ee.WebModule;
import org.jboss.management.j2ee.factory.FactoryUtils;
import org.jboss.management.j2ee.factory.ManagedObjectFactory;

public class WebModuleFactory
implements ManagedObjectFactory {
    private static Logger log = Logger.getLogger(WebModuleFactory.class);
    private HashMap deploymentToModuleNameMap = new HashMap();
    private HashMap containerToModuleNameMap = new HashMap();

    public ObjectName create(MBeanServer server, Object data) {
        if (!(data instanceof DeploymentInfo)) {
            return null;
        }
        DeploymentInfo di = (DeploymentInfo)data;
        String warName = di.shortName;
        ObjectName webModuleService = di.deployedObject;
        String earName = FactoryUtils.findEarParent(di);
        ObjectName jsr77Name = WebModule.create(server, earName, warName, di.localUrl, webModuleService);
        this.deploymentToModuleNameMap.put(di, jsr77Name);
        for (Object next : di.mbeans) {
            try {
                ObjectName servletName = (ObjectName)next;
                this.createServlet(server, jsr77Name, servletName);
            }
            catch (Throwable e) {
                log.debug((Object)("Failed to create JSR-77 servlet: " + next), e);
            }
        }
        return jsr77Name;
    }

    public void destroy(MBeanServer server, Object data) {
        if (!(data instanceof DeploymentInfo)) {
            return;
        }
        DeploymentInfo di = (DeploymentInfo)data;
        ObjectName jsr77Name = (ObjectName)this.deploymentToModuleNameMap.remove(di);
        log.debug((Object)("Destroy module: " + jsr77Name));
        for (Object next : di.mbeans) {
            try {
                ObjectName servletName = (ObjectName)next;
                this.destroyServlet(server, servletName);
            }
            catch (Throwable e) {
                log.debug((Object)("Failed to destroy JSR-77 servlet: " + next), e);
            }
        }
        if (jsr77Name != null) {
            WebModule.destroy(server, jsr77Name);
        }
    }

    public ObjectName createServlet(MBeanServer mbeanServer, ObjectName webModuleName, ObjectName servletServiceName) {
        ObjectName jsr77Name = null;
        ObjectName webContainerName = null;
        try {
            log.debug((Object)("Creating servlet: " + servletServiceName));
            String servletName = servletServiceName.getKeyProperty("name");
            if (servletName != null) {
                jsr77Name = Servlet.create(mbeanServer, webModuleName, webContainerName, servletServiceName);
                this.containerToModuleNameMap.put(servletServiceName, jsr77Name);
                log.debug((Object)("Created servlet: " + servletServiceName + ", module: " + jsr77Name));
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to create servlet: " + servletServiceName), (Throwable)e);
        }
        return jsr77Name;
    }

    public void destroyServlet(MBeanServer server, ObjectName servletServiceName) {
        ObjectName jsr77Name = (ObjectName)this.containerToModuleNameMap.remove(servletServiceName);
        log.debug((Object)("Destroy container: " + servletServiceName + ", module: " + jsr77Name));
        if (jsr77Name != null) {
            Servlet.destroy(server, jsr77Name);
        }
    }
}

