/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.microcontainer;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.bootstrap.AbstractServerImpl;
import org.jboss.bootstrap.BootstrapMetaData;
import org.jboss.bootstrap.microcontainer.TempBasicXMLDeployer;
import org.jboss.bootstrap.spi.microcontainer.MCServer;
import org.jboss.bootstrap.xml.BootstrapParser;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="jboss.system:type=MCServer", isRuntime=true, properties=ManagementProperties.EXPLICIT, description="the MCServer bootstrap view", componentType=@ManagementComponent(type="MCBean", subtype="*"))
public class ServerImpl
extends AbstractServerImpl
implements MCServer {
    public static String BOOTSTRAP_XML_NAME = "bootstrap.xml";
    private BasicBootstrap bootstrap;
    private Kernel kernel;
    private TempBasicXMLDeployer kernelDeployer;

    @Override
    @ManagementProperty(ignored=true)
    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    @ManagementProperty(ignored=true)
    public Map<String, KernelDeployment> getDeployments() {
        Map<String, KernelDeployment> deployments = null;
        if (this.kernelDeployer != null) {
            deployments = this.kernelDeployer.getDeployments();
        }
        return deployments;
    }

    @Override
    protected void doStart(StopWatch watch) throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.kernel = bootstrap.getKernel();
        KernelController controller = this.kernel.getController();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"JBossServer", (String)this.getClass().getName());
        builder.addMethodInstallCallback("addBootstrap");
        builder.addMethodUninstallCallback("removeBootstrap");
        controller.install(builder.getBeanMetaData(), (Object)this);
        URL configURL = this.getConfig().getServerConfigURL();
        URL url = this.getConfig().getBootstrapURL();
        if (url == null) {
            url = new URL(configURL, BOOTSTRAP_XML_NAME);
        }
        this.log.info((Object)("Starting Microcontainer, bootstrapURL=" + url));
        BootstrapMetaData bootstrapMetaData = BootstrapParser.parse(url);
        List<String> bootstrapURLs = bootstrapMetaData.getBootstrapURLs();
        if (bootstrapURLs == null || bootstrapURLs.isEmpty()) {
            throw new IllegalStateException("No bootstrap urls in " + url);
        }
        this.log.debug((Object)("BootstrapURLs=" + bootstrapURLs));
        this.kernelDeployer = new TempBasicXMLDeployer(this.kernel);
        try {
            for (String bootstrapURL : bootstrapURLs) {
                this.log.debug((Object)("Deploying bootstrap xml:" + bootstrapURL));
                url = new URL(configURL, bootstrapURL);
                this.kernelDeployer.deploy(url);
            }
            this.kernelDeployer.validate();
            KernelEventManager eventMgr = this.kernel.getEventManager();
            AbstractEvent startEvent = new AbstractEvent((Object)eventMgr, "org.jboss.system.server.started", 0L, System.currentTimeMillis(), (Object)new Long(watch.getLapTime()));
            eventMgr.fireKernelEvent((KernelEvent)startEvent);
            this.bootstrap = bootstrap;
        }
        catch (Throwable t) {
            try {
                this.kernelDeployer.shutdown();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw t;
        }
    }

    @Override
    protected void doShutdown() {
        try {
            if (this.bootstrap != null) {
                KernelEvent stopEvent = this.bootstrap.createEvent("org.jboss.system.server.stopped", null);
                this.bootstrap.fireKernelEvent(stopEvent);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error sending stop notification", t);
        }
        try {
            if (this.kernelDeployer != null) {
                this.kernelDeployer.shutdown();
                this.kernelDeployer = null;
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error stopping xml deployer", t);
        }
        try {
            Kernel currentKernel = null;
            if (this.kernel != null) {
                currentKernel = this.kernel;
                this.kernel = null;
            } else if (this.bootstrap != null) {
                currentKernel = this.bootstrap.getKernel();
            }
            this.bootstrap = null;
            if (currentKernel != null) {
                KernelController controller = currentKernel.getController();
                controller.shutdown();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error stopping xml deployer", t);
        }
    }
}

