/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metamodel.descriptor;

import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.Ref;

public class ResourceEnvRef
extends Ref {
    private static final Logger log = Logger.getLogger(ResourceEnvRef.class);
    private String resRefName;
    private String resType;
    private String resAuth;
    private String resSharingScope;
    private String mappedName;
    private String jndiName;
    private String resourceName;

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
        this.mappedName = jndiName;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public String getResRefName() {
        return this.resRefName;
    }

    public void setResRefName(String resRefName) {
        this.resRefName = resRefName;
    }

    public String getResType() {
        return this.resType;
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public String getResAuth() {
        return this.resAuth;
    }

    public void setResAuth(String resAuth) {
        this.resAuth = resAuth;
    }

    public String getAuthorizationType() {
        return this.resAuth;
    }

    public String getResSharingScope() {
        return this.resSharingScope;
    }

    public void setResSharingScope(String resSharingScope) {
        this.resSharingScope = resSharingScope;
    }

    public boolean isShareable() {
        return this.resSharingScope == null || this.resSharingScope.equals("Shareable");
    }

    public void merge(ResourceEnvRef ref) {
        if (ref.getJndiName() != null) {
            this.setJndiName(ref.getJndiName());
            this.setMappedName(ref.getJndiName());
        }
        if (ref.getResourceName() != null) {
            this.setResourceName(ref.getResourceName());
            String mappedName = ref.getResourceName();
            if (mappedName.startsWith("java:")) {
                this.setMappedName(ref.getResourceName());
            } else {
                this.setMappedName("java:" + ref.getResourceName());
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[ResourceEnvRef:");
        sb.append("resRefName=").append(this.resRefName);
        sb.append(",resType=").append(this.resType);
        sb.append(",jndiName=").append(this.jndiName);
        sb.append(",mappedName=").append(this.mappedName);
        sb.append("]");
        return sb.toString();
    }
}

