/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.management.timer.TimerMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Classes;
import org.jboss.varia.scheduler.Schedulable;
import org.jboss.varia.scheduler.ScheduleManager;
import org.jboss.varia.scheduler.SchedulerMBean;
import org.jboss.varia.scheduler.TCLActions;

public class Scheduler
extends ServiceMBeanSupport
implements SchedulerMBean {
    public static String JNDI_NAME = "scheduler:domain";
    public static String JMX_NAME = "scheduler";
    public static String DEFAULT_TIMER_NAME = ScheduleManager.DEFAULT_TIMER_NAME;
    private static final int NOTIFICATION = 0;
    private static final int DATE = 1;
    private static final int REPETITIONS = 2;
    private static final int SCHEDULER_NAME = 3;
    private static final int NULL = 4;
    private long mActualSchedulePeriod;
    private long mRemainingRepetitions = 0L;
    private int mNotificationID = -1;
    private String mTimerName = DEFAULT_TIMER_NAME;
    private ObjectName mTimerObjectName;
    private TimerMBean mTimer;
    private NotificationEmitter mTimerEmitter;
    private Schedulable mSchedulable;
    private boolean mScheduleIsStarted = false;
    private boolean mWaitForNextCallToStop = false;
    private boolean mStartOnStart = false;
    private boolean mIsRestartPending = true;
    private boolean mUseMBean = false;
    private Class mSchedulableClass;
    private String mSchedulableArguments;
    private String[] mSchedulableArgumentList = new String[0];
    private String mSchedulableArgumentTypes;
    private Class[] mSchedulableArgumentTypeList = new Class[0];
    private ObjectName mSchedulableMBean;
    private String mSchedulableMBeanMethod;
    private String mSchedulableMBeanMethodName;
    private int[] mSchedulableMBeanArguments = new int[0];
    private String[] mSchedulableMBeanArgumentTypes = new String[0];
    private SimpleDateFormat mDateFormatter;
    private Date mStartDate;
    private String mStartDateString;
    private boolean mStartDateIsNow;
    private long mSchedulePeriod;
    private long mInitialRepetitions;
    private boolean mFixedRate = false;
    private NotificationListener mListener;

    public Scheduler() {
    }

    public Scheduler(String pSchedulableClass, long pSchedulePeriod) {
        this.setStartAtStartup(true);
        this.setSchedulableClass(pSchedulableClass);
        this.setSchedulePeriod(pSchedulePeriod);
    }

    public Scheduler(String pSchedulableClass, String pInitArguments, String pInitTypes, String pInitialStartDate, long pSchedulePeriod, long pNumberOfRepetitions) {
        this.setStartAtStartup(true);
        this.setSchedulableClass(pSchedulableClass);
        this.setSchedulableArguments(pInitArguments);
        this.setSchedulableArgumentTypes(pInitTypes);
        this.setInitialStartDate(pInitialStartDate);
        this.setSchedulePeriod(pSchedulePeriod);
        this.setInitialRepetitions(pNumberOfRepetitions);
    }

    public Scheduler(String pSchedulableClass, String pInitArguments, String pInitTypes, String pDateFormat, String pInitialStartDate, long pSchedulePeriod, long pNumberOfRepetitions) {
        this.setStartAtStartup(true);
        this.setSchedulableClass(pSchedulableClass);
        this.setSchedulableArguments(pInitArguments);
        this.setSchedulableArgumentTypes(pInitTypes);
        this.setDateFormat(pDateFormat);
        this.setInitialStartDate(pInitialStartDate);
        this.setSchedulePeriod(pSchedulePeriod);
        this.setInitialRepetitions(pNumberOfRepetitions);
    }

    private void checkMBean() {
        if (this.mSchedulableMBean == null) {
            this.log.debug((Object)"Schedulable MBean Object Name is not set");
            throw new InvalidParameterException("Schedulable MBean must be set");
        }
        if (this.mSchedulableMBeanMethodName == null) {
            this.mSchedulableMBeanMethodName = "perform";
            this.mSchedulableMBeanArguments = new int[]{1, 2};
            this.mSchedulableMBeanArgumentTypes = new String[]{Date.class.getName(), Integer.TYPE.getName()};
        }
    }

    private void createSchedulable() {
        if (this.mSchedulableClass == null) {
            throw new InvalidParameterException("Schedulable Class not set");
        }
        if (this.mSchedulableArgumentList.length != this.mSchedulableArgumentTypeList.length) {
            throw new InvalidParameterException("Schedulable Class Arguments and Types do not match in length");
        }
        Object[] lArgumentList = new Object[this.mSchedulableArgumentTypeList.length];
        try {
            for (int i = 0; i < this.mSchedulableArgumentTypeList.length; ++i) {
                Class lClass = this.mSchedulableArgumentTypeList[i];
                if (lClass == Boolean.TYPE) {
                    lArgumentList[i] = new Boolean(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Integer.TYPE) {
                    lArgumentList[i] = new Integer(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Long.TYPE) {
                    lArgumentList[i] = new Long(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Short.TYPE) {
                    lArgumentList[i] = new Short(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Float.TYPE) {
                    lArgumentList[i] = new Float(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Double.TYPE) {
                    lArgumentList[i] = new Double(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Byte.TYPE) {
                    lArgumentList[i] = new Byte(this.mSchedulableArgumentList[i]);
                    continue;
                }
                if (lClass == Character.TYPE) {
                    lArgumentList[i] = new Character(this.mSchedulableArgumentList[i].charAt(0));
                    continue;
                }
                Constructor lConstructor = lClass.getConstructor(String.class);
                lArgumentList[i] = lConstructor.newInstance(this.mSchedulableArgumentList[i]);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not load or create constructor argument", (Throwable)e);
            throw new InvalidParameterException("Could not load or create a constructor argument");
        }
        try {
            Constructor lSchedulableConstructor = this.mSchedulableClass.getConstructor(this.mSchedulableArgumentTypeList);
            this.mSchedulable = (Schedulable)lSchedulableConstructor.newInstance(lArgumentList);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not find the constructor or create Schedulable instance", (Throwable)e);
            throw new InvalidParameterException("Could not find the constructor or create the Schedulable Instance");
        }
    }

    private Date getNow() {
        long now = System.currentTimeMillis();
        return new Date(now + 1000L);
    }

    private void initStartDate() {
        if (this.mStartDateIsNow) {
            this.mStartDate = this.getNow();
        } else if (this.mStartDate.before(new Date())) {
            long lNow = new Date().getTime() + 100L;
            long lSkipRepeats = (lNow - this.mStartDate.getTime()) / this.mActualSchedulePeriod + 1L;
            this.log.debug((Object)("Old start date: " + this.mStartDate + ", now: " + new Date(lNow) + ", Skip repeats: " + lSkipRepeats));
            if (this.mRemainingRepetitions > 0L) {
                if (lSkipRepeats >= this.mRemainingRepetitions) {
                    this.log.info((Object)"No repetitions left because start date is in the past and could not be reached by Initial Repetitions * Schedule Period");
                    return;
                }
                this.mRemainingRepetitions -= lSkipRepeats;
            }
            this.mStartDate = new Date(this.mStartDate.getTime() + lSkipRepeats * this.mActualSchedulePeriod);
        }
    }

    public void startSchedule() {
        if (this.isStarted()) {
            this.log.debug((Object)"already started");
            return;
        }
        if (this.mUseMBean) {
            this.checkMBean();
        } else {
            this.createSchedulable();
        }
        this.mRemainingRepetitions = this.mInitialRepetitions;
        this.mActualSchedulePeriod = this.mSchedulePeriod;
        this.initStartDate();
        this.log.debug((Object)("Schedule initial call to: " + this.mStartDate + ", remaining repetitions: " + this.mRemainingRepetitions));
        this.mNotificationID = this.mTimer.addNotification("Schedule", "Scheduler Notification", null, this.mStartDate, new Long(this.mActualSchedulePeriod), this.mRemainingRepetitions < 0L ? new Long(0L) : new Long(this.mRemainingRepetitions), this.mFixedRate);
        this.mListener = this.mUseMBean ? new MBeanListener() : new PojoScheduler();
        this.mTimerEmitter.addNotificationListener(this.mListener, new ScheduleManager.IdNotificationFilter(this.mNotificationID), null);
        this.mScheduleIsStarted = true;
        this.mIsRestartPending = false;
    }

    public void stopSchedule() {
        this.stopSchedule(true);
    }

    public void stopSchedule(boolean pDoItNow) {
        block7: {
            this.log.debug((Object)("stopSchedule(" + pDoItNow + ")"));
            try {
                if (this.mNotificationID < 0) {
                    this.mScheduleIsStarted = false;
                    this.mWaitForNextCallToStop = false;
                    return;
                }
                if (pDoItNow) {
                    this.log.debug((Object)("stopSchedule(), removing schedule id: " + this.mNotificationID));
                    this.mWaitForNextCallToStop = false;
                    if (this.mListener != null) {
                        this.mTimerEmitter.removeNotificationListener(this.mListener);
                        try {
                            this.mTimer.removeNotification(this.mNotificationID);
                        }
                        catch (InstanceNotFoundException e) {
                            this.log.trace((Object)e);
                        }
                        this.mListener = null;
                    }
                    this.mNotificationID = -1;
                    this.mScheduleIsStarted = false;
                    break block7;
                }
                this.mWaitForNextCallToStop = true;
            }
            catch (Exception e) {
                this.log.error((Object)"stopSchedule failed", (Throwable)e);
            }
        }
    }

    public void restartSchedule() {
        this.stopSchedule();
        this.startSchedule();
    }

    public String getSchedulableClass() {
        if (this.mSchedulableClass == null) {
            return null;
        }
        return this.mSchedulableClass.getName();
    }

    public void setSchedulableClass(String pSchedulableClass) throws InvalidParameterException {
        if (pSchedulableClass == null || pSchedulableClass.equals("")) {
            throw new InvalidParameterException("Schedulable Class cannot be empty or undefined");
        }
        try {
            ClassLoader loader = TCLActions.getContextClassLoader();
            this.mSchedulableClass = loader.loadClass(pSchedulableClass);
            if (!Scheduler.isSchedulable(this.mSchedulableClass)) {
                String msg = "Given class " + pSchedulableClass + " is not instance of Schedulable";
                StringBuffer info = new StringBuffer(msg);
                info.append("\nThe SchedulableClass info:");
                Classes.displayClassInfo((Class)this.mSchedulableClass, (StringBuffer)info);
                info.append("\nSchedulable.class info:");
                Classes.displayClassInfo(Schedulable.class, (StringBuffer)info);
                this.log.debug((Object)info.toString());
                throw new InvalidParameterException(msg);
            }
        }
        catch (ClassNotFoundException e) {
            this.log.info((Object)("Failed to find: " + pSchedulableClass), (Throwable)e);
            throw new InvalidParameterException("Given class " + pSchedulableClass + " is not  not found");
        }
        this.mIsRestartPending = true;
        this.mUseMBean = false;
    }

    public String getSchedulableArguments() {
        return this.mSchedulableArguments;
    }

    public void setSchedulableArguments(String pArgumentList) {
        if (pArgumentList == null || pArgumentList.equals("")) {
            this.mSchedulableArgumentList = new String[0];
        } else {
            StringTokenizer lTokenizer = new StringTokenizer(pArgumentList, ",");
            Vector<String> lList = new Vector<String>();
            while (lTokenizer.hasMoreTokens()) {
                String lToken = lTokenizer.nextToken().trim();
                if (lToken.equals("")) {
                    lList.add("null");
                    continue;
                }
                lList.add(lToken);
            }
            this.mSchedulableArgumentList = lList.toArray(new String[0]);
        }
        this.mSchedulableArguments = pArgumentList;
        this.mIsRestartPending = true;
    }

    public String getSchedulableArgumentTypes() {
        return this.mSchedulableArgumentTypes;
    }

    public void setSchedulableArgumentTypes(String pTypeList) throws InvalidParameterException {
        if (pTypeList == null || pTypeList.equals("")) {
            this.mSchedulableArgumentTypeList = new Class[0];
        } else {
            StringTokenizer lTokenizer = new StringTokenizer(pTypeList, ",");
            Vector<Class<Short>> lList = new Vector<Class<Short>>();
            while (lTokenizer.hasMoreTokens()) {
                String lToken = lTokenizer.nextToken().trim();
                Class<Comparable<Short>> lClass = null;
                if (lToken.equals("short")) {
                    lClass = Short.TYPE;
                } else if (lToken.equals("int")) {
                    lClass = Integer.TYPE;
                } else if (lToken.equals("long")) {
                    lClass = Long.TYPE;
                } else if (lToken.equals("byte")) {
                    lClass = Byte.TYPE;
                } else if (lToken.equals("char")) {
                    lClass = Character.TYPE;
                } else if (lToken.equals("float")) {
                    lClass = Float.TYPE;
                } else if (lToken.equals("double")) {
                    lClass = Double.TYPE;
                } else if (lToken.equals("boolean")) {
                    lClass = Boolean.TYPE;
                }
                if (lClass == null) {
                    try {
                        ClassLoader loader = TCLActions.getContextClassLoader();
                        lClass = loader.loadClass(lToken);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new InvalidParameterException("The argument type: " + lToken + " is not a valid class or could not be found");
                    }
                }
                lList.add(lClass);
            }
            this.mSchedulableArgumentTypeList = lList.toArray(new Class[0]);
        }
        this.mSchedulableArgumentTypes = pTypeList;
        this.mIsRestartPending = true;
    }

    public String getSchedulableMBean() {
        return this.mSchedulableMBean == null ? null : this.mSchedulableMBean.toString();
    }

    public void setSchedulableMBean(String pSchedulableMBean) throws InvalidParameterException {
        if (pSchedulableMBean == null) {
            throw new InvalidParameterException("Schedulable MBean must be specified");
        }
        try {
            this.mSchedulableMBean = new ObjectName(pSchedulableMBean);
            this.mUseMBean = true;
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidParameterException("Schedulable MBean name invalid " + pSchedulableMBean);
        }
    }

    public String getSchedulableMBeanMethod() {
        return this.mSchedulableMBeanMethod;
    }

    public void setSchedulableMBeanMethod(String pSchedulableMBeanMethod) throws InvalidParameterException {
        String lMethodName;
        if (pSchedulableMBeanMethod == null) {
            this.mSchedulableMBeanMethod = null;
            return;
        }
        int lIndex = pSchedulableMBeanMethod.indexOf(40);
        if (lIndex == -1) {
            lMethodName = pSchedulableMBeanMethod.trim();
            this.mSchedulableMBeanArguments = new int[0];
            this.mSchedulableMBeanArgumentTypes = new String[0];
        } else {
            lMethodName = pSchedulableMBeanMethod.substring(0, lIndex).trim();
        }
        if (lMethodName.equals("")) {
            lMethodName = "perform";
        }
        if (lIndex >= 0) {
            String lRest;
            int lIndex2 = pSchedulableMBeanMethod.indexOf(41);
            if (lIndex2 < lIndex) {
                throw new InvalidParameterException("Schedulable MBean Method: closing bracket must be after opening bracket");
            }
            if (lIndex2 < pSchedulableMBeanMethod.length() - 1 && (lRest = pSchedulableMBeanMethod.substring(lIndex2 + 1).trim()).length() > 0) {
                throw new InvalidParameterException("Schedulable MBean Method: nothing should be after closing bracket");
            }
            String lArguments = pSchedulableMBeanMethod.substring(lIndex + 1, lIndex2).trim();
            if (lArguments.equals("")) {
                this.mSchedulableMBeanArguments = new int[0];
                this.mSchedulableMBeanArgumentTypes = new String[0];
            } else {
                StringTokenizer lTokenizer = new StringTokenizer(lArguments, ", ");
                this.mSchedulableMBeanArguments = new int[lTokenizer.countTokens()];
                this.mSchedulableMBeanArgumentTypes = new String[lTokenizer.countTokens()];
                int i = 0;
                while (lTokenizer.hasMoreTokens()) {
                    String lToken = lTokenizer.nextToken().trim();
                    if (lToken.equals("NOTIFICATION")) {
                        this.mSchedulableMBeanArguments[i] = 0;
                        this.mSchedulableMBeanArgumentTypes[i] = Notification.class.getName();
                    } else if (lToken.equals("DATE")) {
                        this.mSchedulableMBeanArguments[i] = 1;
                        this.mSchedulableMBeanArgumentTypes[i] = Date.class.getName();
                    } else if (lToken.equals("REPETITIONS")) {
                        this.mSchedulableMBeanArguments[i] = 2;
                        this.mSchedulableMBeanArgumentTypes[i] = Long.TYPE.getName();
                    } else if (lToken.equals("SCHEDULER_NAME")) {
                        this.mSchedulableMBeanArguments[i] = 3;
                        this.mSchedulableMBeanArgumentTypes[i] = ObjectName.class.getName();
                    } else {
                        this.mSchedulableMBeanArguments[i] = 4;
                        this.mSchedulableMBeanArgumentTypes[i] = lToken;
                    }
                    ++i;
                }
            }
        }
        this.mSchedulableMBeanMethodName = lMethodName;
        this.mSchedulableMBeanMethod = pSchedulableMBeanMethod;
    }

    public boolean isUsingMBean() {
        return this.mUseMBean;
    }

    public long getSchedulePeriod() {
        return this.mSchedulePeriod;
    }

    public void setSchedulePeriod(long pPeriod) {
        if (pPeriod <= 0L) {
            throw new InvalidParameterException("Schedulable Period may be not less or equals than 0");
        }
        this.mSchedulePeriod = pPeriod;
        this.mIsRestartPending = true;
    }

    public String getDateFormat() {
        if (this.mDateFormatter == null) {
            this.mDateFormatter = new SimpleDateFormat();
        }
        return this.mDateFormatter.toPattern();
    }

    public void setDateFormat(String dateFormat) {
        this.mDateFormatter = dateFormat == null || dateFormat.trim().length() == 0 ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
    }

    public String getInitialStartDate() {
        return this.mStartDateString;
    }

    public void setInitialStartDate(String pStartDate) {
        String string = this.mStartDateString = pStartDate == null ? "" : pStartDate.trim();
        if (this.mStartDateString.equals("")) {
            this.mStartDate = new Date(0L);
        } else if (this.mStartDateString.equals("NOW")) {
            this.mStartDate = this.getNow();
            this.mStartDateIsNow = true;
        } else {
            try {
                long lDate = new Long(pStartDate);
                this.mStartDate = new Date(lDate);
                this.mStartDateIsNow = false;
            }
            catch (NumberFormatException e) {
                try {
                    if (this.mDateFormatter == null) {
                        this.mDateFormatter = new SimpleDateFormat();
                    }
                    this.mStartDate = this.mDateFormatter.parse(this.mStartDateString);
                    this.mStartDateIsNow = false;
                }
                catch (Exception e2) {
                    this.log.error((Object)("Could not parse given date string: " + this.mStartDateString), (Throwable)e2);
                    throw new InvalidParameterException("Schedulable Date is not of correct format: " + this.mStartDateString);
                }
            }
        }
        this.log.debug((Object)("Initial Start Date is set to: " + this.mStartDate));
    }

    public long getInitialRepetitions() {
        return this.mInitialRepetitions;
    }

    public void setInitialRepetitions(long pNumberOfCalls) {
        if (pNumberOfCalls <= 0L) {
            pNumberOfCalls = -1L;
        }
        this.mInitialRepetitions = pNumberOfCalls;
        this.mIsRestartPending = true;
    }

    public long getRemainingRepetitions() {
        return this.mRemainingRepetitions;
    }

    public boolean isStarted() {
        return this.mScheduleIsStarted;
    }

    public boolean isRestartPending() {
        return this.mIsRestartPending;
    }

    public boolean isStartAtStartup() {
        return this.mStartOnStart;
    }

    public void setStartAtStartup(boolean pStartAtStartup) {
        this.mStartOnStart = pStartAtStartup;
    }

    public boolean isActive() {
        return this.isStarted() && this.mRemainingRepetitions != 0L;
    }

    public String getTimerName() {
        return this.mTimerName;
    }

    public void setTimerName(String pTimerName) {
        this.mTimerName = pTimerName;
    }

    public void setFixedRate(boolean fixedRate) {
        this.mFixedRate = fixedRate;
    }

    public boolean getFixedRate() {
        return this.mFixedRate;
    }

    protected void startService() throws Exception {
        this.mTimerObjectName = new ObjectName(this.mTimerName);
        if (!this.getServer().isRegistered(this.mTimerObjectName)) {
            this.getServer().createMBean(Timer.class.getName(), this.mTimerObjectName);
        }
        this.mTimer = MBeanServerInvocationHandler.newProxyInstance(this.getServer(), this.mTimerObjectName, TimerMBean.class, true);
        this.mTimerEmitter = (NotificationEmitter)((Object)this.mTimer);
        if (!this.mTimer.isActive()) {
            this.mTimer.start();
        }
        if (this.mStartOnStart) {
            this.log.debug((Object)"Start Scheduler on start up time");
            this.startSchedule();
        }
    }

    protected void stopService() {
        this.stopSchedule();
    }

    private static boolean isSchedulable(Class c) {
        boolean lFound = false;
        block0: do {
            Class<?>[] lInterfaces = c.getInterfaces();
            for (int i = 0; i < lInterfaces.length; ++i) {
                if (lInterfaces[i] != Schedulable.class) continue;
                lFound = true;
                continue block0;
            }
        } while ((c = c.getSuperclass()) != null && !lFound);
        return lFound;
    }

    public class MBeanListener
    extends BaseListener {
        protected void invoke(Notification notification) {
            Object[] lArguments = new Object[Scheduler.this.mSchedulableMBeanArguments.length];
            block8: for (int i = 0; i < lArguments.length; ++i) {
                switch (Scheduler.this.mSchedulableMBeanArguments[i]) {
                    case 0: {
                        lArguments[i] = notification;
                        continue block8;
                    }
                    case 1: {
                        lArguments[i] = new Date(notification.getTimeStamp());
                        continue block8;
                    }
                    case 2: {
                        lArguments[i] = new Long(Scheduler.this.mRemainingRepetitions);
                        continue block8;
                    }
                    case 3: {
                        lArguments[i] = Scheduler.this.getServiceName();
                        continue block8;
                    }
                    default: {
                        lArguments[i] = null;
                    }
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.debug((Object)("invoke " + Scheduler.this.mSchedulableMBean + " " + Scheduler.this.mSchedulableMBeanMethodName));
                this.log.debug((Object)("arguments: " + Arrays.asList(lArguments)));
                this.log.debug((Object)("argument types: " + Arrays.asList(Scheduler.this.mSchedulableMBeanArgumentTypes)));
            }
            try {
                Scheduler.this.getServer().invoke(Scheduler.this.mSchedulableMBean, Scheduler.this.mSchedulableMBeanMethodName, lArguments, Scheduler.this.mSchedulableMBeanArgumentTypes);
            }
            catch (Exception e) {
                this.log.error((Object)("Invoke failed for " + Scheduler.this.mSchedulableMBean + " " + Scheduler.this.mSchedulableMBeanMethodName), (Throwable)e);
            }
        }
    }

    public class PojoScheduler
    extends BaseListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invoke(Notification notification) {
            ClassLoader currentTCL = TCLActions.getContextClassLoader();
            try {
                ClassLoader loader = TCLActions.getClassLoader(Scheduler.this.mSchedulable.getClass());
                TCLActions.setContextClassLoader(loader);
                Date lTimeStamp = new Date(notification.getTimeStamp());
                Scheduler.this.mSchedulable.perform(lTimeStamp, Scheduler.this.getRemainingRepetitions());
            }
            catch (Exception e) {
                this.log.error((Object)"Scheduler.perform call failed", (Throwable)e);
            }
            finally {
                TCLActions.setContextClassLoader(currentTCL);
            }
        }
    }

    public abstract class BaseListener
    implements NotificationListener {
        final Logger log = Logger.getLogger(BaseListener.class);

        public void handleNotification(Notification notification, Object handback) {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("handleNotification: " + notification));
            }
            if (!Scheduler.this.isStarted()) {
                this.log.trace((Object)"Scheduler not started");
                Scheduler.this.stopSchedule();
                return;
            }
            if (Scheduler.this.mRemainingRepetitions == 0L) {
                this.log.trace((Object)"No more repetitions");
                Scheduler.this.stopSchedule();
                return;
            }
            if (Scheduler.this.mRemainingRepetitions > 0L) {
                Scheduler.this.mRemainingRepetitions--;
                if (trace) {
                    this.log.trace((Object)("Remaining repetitions: " + Scheduler.this.mRemainingRepetitions));
                }
            }
            this.invoke(notification);
            if (Scheduler.this.mWaitForNextCallToStop) {
                Scheduler.this.stopSchedule();
            }
        }

        protected abstract void invoke(Notification var1);
    }
}

