/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.managed;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.services.binding.ServiceBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingMapper
extends MetaMapper<Map<String, Set<ServiceBinding>>> {
    private static final Logger log = Logger.getLogger(ServiceBindingMapper.class);
    public static final MapCompositeMetaType TYPE;
    public static final CompositeMetaType SERVICE_BINDING_TYPE;
    public static final CollectionMetaType MAP_VALUE_TYPE;

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return Map.class;
    }

    public MetaValue createMetaValue(MetaType metaType, Map<String, Set<ServiceBinding>> object) {
        HashMap<String, CollectionValueSupport> map = new HashMap<String, CollectionValueSupport>();
        for (Map.Entry<String, Set<ServiceBinding>> mapEntry : object.entrySet()) {
            TreeSet<CompositeValue> tmp = new TreeSet<CompositeValue>(new FullyQualifiedNameComparator());
            for (ServiceBinding b : mapEntry.getValue()) {
                try {
                    MapCompositeValueSupport cvs = new MapCompositeValueSupport((MetaType)SERVICE_BINDING_TYPE);
                    cvs.put("serviceName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getServiceName())));
                    cvs.put("bindingName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getBindingName())));
                    cvs.put("fullyQualifiedName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getFullyQualifiedName())));
                    cvs.put("description", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getDescription())));
                    cvs.put("hostName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getHostName())));
                    InetAddress inet = b.getBindAddress();
                    if (inet != null) {
                        ArrayValueSupport avs = new ArrayValueSupport(ArrayMetaType.getPrimitiveArrayType(byte[].class));
                        avs.setValue((Object)inet.getAddress());
                        cvs.put("bindAddress", (MetaValue)avs);
                    } else {
                        cvs.put("bindAddress", null);
                    }
                    cvs.put("port", (MetaValue)SimpleValueSupport.wrap((int)b.getPort()));
                    tmp.add((CompositeValue)cvs);
                }
                catch (Exception e) {
                    log.warn((Object)("Skipping binding: " + b), (Throwable)e);
                }
            }
            MetaValue[] elements = tmp.toArray(new MetaValue[tmp.size()]);
            CollectionValueSupport bindingSet = new CollectionValueSupport(MAP_VALUE_TYPE, elements);
            map.put(mapEntry.getKey(), bindingSet);
        }
        return new MapCompositeValueSupport(map, (MetaType)MAP_VALUE_TYPE);
    }

    public Map<String, Set<ServiceBinding>> unwrapMetaValue(MetaValue metaValue) {
        return null;
    }

    static {
        String[] itemNames = new String[]{"serviceName", "bindingName", "fullyQualifiedName", "description", "hostName", "bindAddress", "port"};
        String[] itemDescriptions = new String[]{"the name of the service to which this binding applies", "a qualifier identifying which particular binding within the service this is", "the fully qualified binding name", "description of the binding", "the host name or string notation IP address to use for the binding", "byte[] representing the InetAddress of the interface to use for the binding", "the port to use for the binding"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, ArrayMetaType.getPrimitiveArrayType(byte[].class), SimpleMetaType.INTEGER_PRIMITIVE};
        SERVICE_BINDING_TYPE = new ImmutableCompositeMetaType(ServiceBinding.class.getName(), "Service Binding", itemNames, itemDescriptions, itemTypes);
        MAP_VALUE_TYPE = new CollectionMetaType(Set.class.getName(), (MetaType)SERVICE_BINDING_TYPE);
        TYPE = new MapCompositeMetaType((MetaType)MAP_VALUE_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FullyQualifiedNameComparator
    implements Comparator<CompositeValue> {
        private FullyQualifiedNameComparator() {
        }

        @Override
        public int compare(CompositeValue o1, CompositeValue o2) {
            SimpleValue sv1 = (SimpleValue)o1.get("fullyQualifiedName");
            if (sv1 == null) {
                throw new IllegalStateException(o1 + " has no fullyQualifiedName");
            }
            SimpleValue sv2 = (SimpleValue)o2.get("fullyQualifiedName");
            if (sv2 == null) {
                throw new IllegalStateException(o2 + " has no fullyQualifiedName");
            }
            String name1 = (String)((Object)sv1.getValue());
            String name2 = (String)((Object)sv2.getValue());
            return name1.compareTo(name2);
        }
    }
}

