/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition.parser;

import org.jboss.aspects.dbc.condition.parser.BeanshellGenerator;
import org.jboss.aspects.dbc.condition.parser.BooleanExpression;
import org.jboss.aspects.dbc.condition.parser.ExistsExpression;
import org.jboss.aspects.dbc.condition.parser.Expression;
import org.jboss.aspects.dbc.condition.parser.ForAllExpression;
import org.jboss.aspects.dbc.condition.parser.ImpliesExpression;
import org.jboss.aspects.dbc.condition.parser.JavaExpression;

public class ExpressionParser {
    static final String FORALL = "forall ";
    static final String EXISTS = "exists ";
    static final String IMPLIES = " implies ";
    static final String JAVA = "java: ";
    static final String IN = " in ";
    static final String SEPARATOR = " | ";

    public static Expression parseExpression(String expr) {
        return ExpressionParser.parse(expr);
    }

    private static Expression parse(String expr) {
        if ((expr = expr.trim()).startsWith(FORALL)) {
            return ExpressionParser.parseForAll(expr);
        }
        if (expr.startsWith(EXISTS)) {
            return ExpressionParser.parseExists(expr);
        }
        if (expr.indexOf(IMPLIES) > 0) {
            return ExpressionParser.parseImplies(expr);
        }
        if (expr.startsWith(JAVA)) {
            return ExpressionParser.parseJava(expr);
        }
        return ExpressionParser.parseBoolean(expr);
    }

    private static Expression parseForAll(String expr) {
        int in = expr.indexOf(IN);
        if (in < 0) {
            throw new RuntimeException("forall expressions must have an 'in' clause: " + expr);
        }
        String declaration = expr.substring(FORALL.length(), in);
        int sep = expr.indexOf(SEPARATOR);
        if (sep < 0) {
            throw new RuntimeException("forall expressions must have a '|': " + expr);
        }
        String collection = expr.substring(in + IN.length(), sep);
        String body = expr.substring(sep + SEPARATOR.length());
        Expression sub = ExpressionParser.parse(body);
        ForAllExpression forAll = new ForAllExpression(declaration, collection, sub);
        return forAll;
    }

    private static Expression parseExists(String expr) {
        int in = expr.indexOf(IN);
        if (in < 0) {
            throw new RuntimeException("exists expressions must have an 'in' clause: " + expr);
        }
        String declaration = expr.substring(EXISTS.length(), in);
        int sep = expr.indexOf(SEPARATOR);
        if (sep < 0) {
            throw new RuntimeException("exists expressions must have a '|': " + expr);
        }
        String collection = expr.substring(in + IN.length(), sep);
        String body = expr.substring(sep + SEPARATOR.length());
        Expression sub = ExpressionParser.parse(body);
        ExistsExpression exists = new ExistsExpression(declaration, collection, sub);
        return exists;
    }

    private static Expression parseImplies(String expr) {
        int impl = expr.indexOf(IMPLIES);
        String exprA = expr.substring(0, impl);
        String exprB = expr.substring(impl + IMPLIES.length());
        if (exprA.trim().length() == 0 || exprB.trim().length() == 0) {
            throw new RuntimeException("implies expressions must take two simple boolean expressions: " + expr);
        }
        if (exprA.endsWith(";")) {
            exprA = expr.substring(0, expr.length() - 1);
        }
        try {
            Expression condA = ExpressionParser.parse(exprA);
            Expression condB = ExpressionParser.parse(exprB);
            ImpliesExpression implies = new ImpliesExpression((BooleanExpression)condA, (BooleanExpression)condB);
            return implies;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("implies expressions must take two simple boolean expressions: " + expr);
        }
    }

    private static Expression parseJava(String expr) {
        expr = expr.substring(JAVA.length());
        return new JavaExpression(expr);
    }

    private static Expression parseBoolean(String expr) {
        if (expr.endsWith(";")) {
            expr = expr.substring(0, expr.length() - 1);
        }
        return new BooleanExpression(expr);
    }

    public static void main(String[] args) {
        ExpressionParser.doit("a == b");
        ExpressionParser.doit("a == b implies b == a");
        ExpressionParser.doit("forall IEmployee e in getEmployees() | getRooms().contains(e.getOffice());");
        ExpressionParser.doit("exists IEmployee e in getEmployees() | !getRooms().contains(e.getOffice())");
        ExpressionParser.doit("forall IEmployee e1 in getEmployees() | forall IEmployee e2 in getEmployees() | (e1 != e2) implies e1.getOffice() != e2.getOffice()");
        ExpressionParser.doit("java: for (int i = 0){i > 0;}");
    }

    public static void doit(String str) {
        System.out.println(str);
        System.out.println();
        Expression expr = ExpressionParser.parseExpression(str);
        BeanshellGenerator gen = new BeanshellGenerator(expr);
        System.out.println(gen.createBeanshellCode());
        System.out.println("-----------------------");
    }
}

