/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final int port;
    private final RMIClientSocketFactory clientSocketFactory;
    private final RMIServerSocketFactory serverSocketFactory;
    private final Map environment;

    public RMIJRMPServerImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map env) throws IOException {
        super(env);
        this.port = port;
        this.clientSocketFactory = csf;
        this.serverSocketFactory = ssf;
        this.environment = env;
    }

    protected void export() throws IOException {
        UnicastRemoteObject.exportObject(this, this.port, this.clientSocketFactory, this.serverSocketFactory);
    }

    protected String getProtocol() {
        return "rmi";
    }

    public Remote toStub() throws IOException {
        return RemoteObject.toStub(this);
    }

    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.environment);
        UnicastRemoteObject.exportObject(client, this.port, this.clientSocketFactory, this.serverSocketFactory);
        return client;
    }

    protected void closeClient(RMIConnection client) throws IOException {
        UnicastRemoteObject.unexportObject(client, true);
    }

    protected void closeServer() throws IOException {
        UnicastRemoteObject.unexportObject(this, true);
    }
}

