/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.socketfactory;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.jboss.remoting.socketfactory.CreationListenerServerSocket;
import org.jboss.remoting.socketfactory.ServerSocketFactoryWrapper;
import org.jboss.remoting.socketfactory.SocketCreationListener;

public class CreationListenerServerSocketFactory
extends ServerSocketFactory
implements ServerSocketFactoryWrapper,
Serializable {
    private static final long serialVersionUID = -7939318527267014514L;
    private ServerSocketFactory factory;
    private SocketCreationListener listener;

    public CreationListenerServerSocketFactory(ServerSocketFactory factory, SocketCreationListener listener) {
        this.factory = factory;
        this.listener = listener;
    }

    public ServerSocketFactory getFactory() {
        return this.factory;
    }

    public SocketCreationListener getListener() {
        return this.listener;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setListener(SocketCreationListener listener) {
        this.listener = listener;
    }

    public ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = this.factory.createServerSocket();
        return new CreationListenerServerSocket(serverSocket, this.listener);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.factory.createServerSocket(port);
        return new CreationListenerServerSocket(serverSocket, this.listener);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket serverSocket = this.factory.createServerSocket(port, backlog);
        return new CreationListenerServerSocket(serverSocket, this.listener);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocket serverSocket = this.factory.createServerSocket(port, backlog, ifAddress);
        return new CreationListenerServerSocket(serverSocket, this.listener);
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }
}

