/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer.helpers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.vfs.spi.deployer.ManifestMetaData;

public class AbstractManifestMetaData
implements ManifestMetaData,
Externalizable {
    private static final long serialVersionUID = 1L;
    protected transient Manifest manifest;

    public AbstractManifestMetaData() {
    }

    public AbstractManifestMetaData(Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException("Null manifest!");
        }
        this.manifest = manifest;
    }

    protected Manifest getManifest() {
        if (this.manifest == null) {
            throw new IllegalArgumentException("Null manifest!");
        }
        return this.manifest;
    }

    protected String get(Attributes attributes, String name) {
        return attributes != null ? attributes.getValue(name) : null;
    }

    public String getMainAttribute(String name) {
        return this.get(this.getManifest().getMainAttributes(), name);
    }

    public String getAttribute(String attributesName, String name) {
        return this.get(this.getManifest().getAttributes(attributesName), name);
    }

    public String getEntry(String entryName, String name) {
        Map<String, Attributes> entries = this.getManifest().getEntries();
        if (entries != null) {
            return this.get(entries.get(entryName), name);
        }
        return null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        OutputWrapper os = new OutputWrapper(out);
        this.getManifest().write(os);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        InputWrapper is = new InputWrapper(in);
        this.manifest = new Manifest(is);
    }

    private class InputWrapper
    extends InputStream {
        private ObjectInput in;

        public InputWrapper(ObjectInput in) {
            this.in = in;
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private class OutputWrapper
    extends OutputStream {
        private ObjectOutput out;

        public OutputWrapper(ObjectOutput out) {
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

